<?php

$config = array(
	'EvCybertill' => array(

		'live' => array(),

		'dev' => array(
			'client_details' => [
				'wsdl' => 'http://ct28790.c-pos.co.uk/current/CybertillApi_v1_5.wsdl.php',
				'url' => '',
				'user_id' => '',
			],

			'paths' => [
				// The array path to the items in an order
				'items' => 'OrderItem',

				// The array path to the sku in each item
				'sku' => 'OrderItemData.sku',

				// The array path to the totals in an order
				'totals' => 'OrderTotal',

				// The array path to the data on an order
				'data' => 'OrderData',
			],

			'location_id' => 1, // The id of the location orders are being made from

			'customer_id' => null,

			'customer_details' => null,

			'despatch_user_id' => null,

			// The general order details for a cybertill order
			'order_details' => [
				'website_id' => 1, // The id of the website orders are being made from
				'order_total_label' => 'Grand Total', // The label of the total that will be used as the order total (inc tax)
				'order_note' => '', // The note that will be added to the order
				'customer_order_reference' => null, // The customer order reference that will be added to the order
			],

			// The delivery details for a cybertill order
			'order_delivery' => [
				'recipient' => '', // The recipient of the order
				'instructions' => '', // Any instructions for order the store will need
				'giftMessage' => '', // A gift message that will be applied to an order

				'delivery_label' => 'Delivery', // The label of the total that will be used as the delivery total (inc tax)
				'delivery_item_sku' => '', //The SKU to use to add an item representing delivery to an order.
			],

			// The payment details for a cybertill order
			'order_payments' => [
				'type' => 2, // The payment type (2 is credit card)
				'total_label' => 'Grand Total', // The label of the total that will be used as the payment total (inc tax)
				'discount_label' => 'Discount', // The label of the total that will be used as the discount total (inc tax)
				'gift_card_type' => 12, // The payment type for gift cards
				'gift_card_label' => 'Gift Card', // The label of the total that will be used as the gift card total (inc tax)
				'gift_card_data_name' => 'giftCard', // The name of the data on the order that stores the gift card information
			],

			'models' => [
				// The cake model that represents a cybertill item (contains sku field)
				'item_model' => 'EvShop.Variant',

				// The cake model that represents a cybertill inventory (contains stock)
				'stock_model' => 'EvInventory.Inventory',

				// The cake model that represents cybertill pricing for an item
				'pricing_model' => 'EvShop.VariantPricing',

				// The cake model that represents the main order model (as seen in the `model` field in the transactions table)
				'order_model' => 'EvCheckout.Order',
			],
		),

		'redirects' => [
			'reattempt' => [
				'plugin' => 'ev_checkout',
				'controller' => 'orders',
				'action' => 'edit',
				'admin' => true,
			]
		],

		'errorLogging' => [
			'clientSetupFailure' => true,
			'customerSetupFailure' => true,
			'orderSetupFailure' => true,
			'stockNotFound' => true,
			'transactionFailure' => true,
			'dispatchFailure' => true,
		],

		'adminNotifications' => [
			'clientSetupFailure' => true,
			'customerSetupFailure' => true,
			'orderSetupFailure' => true,
			'stockNotFound' => true,
			'transactionFailure' => true,
			'dispatchFailure' => true,
		],

		'queries' => [
			'pullBatchItemLimit' => 500, //The amount of items to batch when pulling data from cybertill on items.
		],
	),
);
