<?php

$path = dirname(__FILE__);
$pluginDir = explode(DS, dirname($path . '../'));

$pluginName = array_pop($pluginDir);
$pluginConfig = Inflector::underscore($pluginName);
Configure::load($pluginName . '.config');

// Load overrides to settings if they exist
$configOverridePath = APP . 'Config' . DS;
$configOverride = 'Plugin' . DS . $pluginConfig . '.php';

if (file_exists($configOverridePath . $configOverride) && is_readable($configOverridePath . $configOverride)) {

	Configure::load($configOverride);
}

require_once (ROOT . DS . 'Plugin' . DS . 'EvCybertill' . DS . 'Config' . DS . 'events.php');

CakeLog::config('missingProduct', array(
	'engine' => 'FileLog',
	'types' => array('missingProduct'),
	'file' => 'EvCybertill-missing-products',
));

CakeLog::config('missingStock', array(
	'engine' => 'FileLog',
	'types' => array('missingStock'),
	'file' => 'EvCybertill-missing-stock',
));

CakeLog::config('cybertillApi', array(
	'engine' => 'FileLog',
	'types' => array('cybertillApi'),
	'file' => 'EvCybertill-cybertill-api',
));
