<?php

App::uses('NumberHelper', 'View/Helper');

class CurrenciesHelper extends NumberHelper {

	public function currency($number, $currency = null, $options = array()) {
		if ($currency === null && !empty(CakeSession::read('EvCurrency.currencyData'))) {
			$currencyData = CakeSession::read('EvCurrency.currencyData');

			$currency = $currencyData['name'];

			CakeNumber::addFormat($currencyData['name'], array(
				'wholeSymbol' => $currencyData['currency_prefix'],
				'wholePosition' => 'before',
				'fractionSymbol' => false,
				'fractionPosition' => 'after',
				'zero' => 0,
				'places' => $currencyData['decimal_places'],
				'thousands' => $currencyData['thousand_separator'],
				'decimals' => $currencyData['decimal_point_char'],
				'negative' => '()',
				'escape' => false,
				'fractionExponent' => 2,
				'after' => false
			));
		}

		return parent::currency($number, $currency, $options);
	}
}
