<div class='edit-form'>

    <div class='edit-form__header'>
        <h1 class='title'>Exchange Rate <span>Administration</span></h1>
    </div>

    <?php

    echo $this->Html->script('admin_form', array('inline'=>false));

    echo $this->Form->create($primaryModel, array(
        'inputDefaults'=>array(
            'empty'=>''
        ),
        'type' => 'file',
        'class' => 'cr'
    ));
    ?>
    <table class="table">
        <thead>
            <tr>
                <th>Currency</th>
                <th>Exchange Rate</th>
                <th>Last Updated</th>
            </tr>
        </thead>
        <tbody>

    <?php foreach ($rates as $rate): ?>
            <tr>
                <td><?php echo $rate['Currency']['name']; ?></td>
                <td><?php echo ($rate['Currency']['exchange_rate'] ? $rate['Currency']['exchange_rate'] : ' - '); ?></td>
                <td><?php echo ($rate['Currency']['exchange_rate_date'] ? $rate['Currency']['exchange_rate_date'] : ' - '); ?></td>
            </tr>
    <?php endforeach; ?>

        </tbody>
        <tfoot>
            <tr>
                <td colspan="3" class="text-center">
                    <button class="btn btn-lg btn-success" type="submit" name="submit"><i class="fa fa-refresh"></i> Update Exchange Rates</button> &nbsp;
                    <a href="/admin/ev_currency/currencies" class="btn btn-lg"><i class="fa fa-money"></i> Manage Currencies</a>
                </td>
            </tr>
        </tfoot>
    </table>
    <?php $this->Form->end(); ?>

</div>