EvCurrency
================
**Author:** Rick | <rick@evoluted.net>

EVCurrency provides a way of storing currency settings, and getting live exchange rates from exchangerate-api.com (Using an evoluted owned account, or can be overridden in the plugin config with the clients account info).

You can then use it alongside your own product pricing table(s) to create/update your foreign prices as well as store detals on the currencies you support. These can then be loaded into cake's currency formatter.

# Installation

This plugin uses the standard plugin installer shell. To install the plugin and populate the database table run the following command from your projects `app` directory.

    Console/cake installer plugin EvCurrency

You also need to load the component in your AppController.php. 

    class AppController extends EvCoreController {

		if (CakePlugin::loaded('EvCurrency')) {
			$this->components[] = 'EvCurrency.Currencies';
		}
	}

### Accessible URLs

`/admin/ev\_currency/exchange\_rates/` - An admin UI to view the current exchange rates, and to manually request an update.

`/ev\_currency/exchange\_rates/cron` - Use this with a cron job to update the stored exchange rates nightly.


# Command Line Script
A command line script is included to update the exchange rates nightly. This can be run like so:

    ./app/Console/cake EvCurrency.ExchangeRate update

It's recommended that you set this up as a nightly cron job.

For the update script to work correctly, the currency must be named properly as the ISO 4217 standard currency code.

# Currency Changed Event

Other parts of the app may want to know when a currency has been updated e.g. the shop so it can updated prices. To do this listen for the `EvCurrency.currencyUpdated` event. It has one data parameter which is the currency id.
