<?php
App::uses('EvCurrencyAppModel', 'EvCurrency.Model');
App::uses('Exchange', 'EvCurrency.Lib');
/**
 * EvCurrenciesCurrency Model
 *
 */
class Currency extends EvCurrencyAppModel {

	public $useTable = 'currencies';

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

/**
 * Update Rates
 *
 * Updates the exchange rates in the EvCurrency plugin table
 * @return boolean
 */
	public function updateRates() {
		$api = new Exchange();

		$baseCurrency = Configure::read('EvCurrency.base_currency');

		$currencies = $this->find('all', array(
			'conditions' => array(
				'is_active' => 1
			)
		));
		$currencyCodes = array();

		foreach ($currencies as $currency) {

			if ($currency['Currency']['name'] != $baseCurrency) {
				$currencyCodes[] = $currency['Currency']['name'];
			}
		}

		$rates = $api->getRates($currencyCodes);

		foreach ($currencies as $currency) {

			if ($currency['Currency']['name'] != $baseCurrency) {

				$currency['Currency']['exchange_rate'] = $rates[$currency['Currency']['name']];
				$currency['Currency']['exchange_rate_date'] = date('Y-m-d G:i:s');
				$this->save($currency['Currency']);
			}
		}

		return;
	}

/**
 * Send an event on save so other parts of the site can be updated with the new changes
 */
	public function afterSave($created, $options = array()) {
		parent::afterSave($created, $options);
		// Dispatch an event to allow behaviors to act on this
		$Event = new CakeEvent('EvCurrency.currencyUpdated', $this, array(
			'id' => $this->data['Currency']['id'],
		));
		$this->getEventManager()->dispatch($Event);
	}

}
