<?php
App::uses('EvCurrencyAppController', 'EvCurrency.Controller');

class ExchangeRatesController extends EvCurrencyAppController {

    public $uses = 'EvCurrency.Currency';

    public function beforeFilter()
    {
        parent::beforeFilter();

        $this->Auth->allow(array(
            'cron'
        ));
    }

    /**
     * Index
     *
     * Used to perform updates to currency rates. Can be used for a cron job.
     *
     * @return null
     */
    public function cron()
    {
        $Model = $this->{$this->modelClass};
        $Model->updateRates();

        $this->autoRender = false; // Disable view rendering

        return;
    }

    /**
     * Admin Index
     *
     * Provides a listing of the stored currency exchange rates, and an option to manually request
     * that the rates are updated.
     *
     * @return View
     */
    public function admin_index()
    {
        $Model = $this->{$this->modelClass};

        if ($this->request->is('post')) {

            $Model->updateRates();

            $this->Session->setFlash(array(
                'title' => 'Exchange Rates Updated',
                'description' => 'The exchange rates were successfully updated!'
            ), 'flash_success');

            return $this->redirect($this->here);

        } else {

            $rates = $Model->find('all');
            $this->set('rates', $rates);
        }
    }
}