<?php

App::uses('EvCurrencyAppController', 'EvCurrency.Controller');

/**
 * Customer Fields Controller
 *
 * @package EvCheckout/CustomerFields
 */
class CurrenciesController extends EvCurrencyAppController {

	public $uses = 'EvCurrency.Currency';

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		unset($fields['Currency.exchange_rate']);
		unset($fields['Currency.exchange_rate_date']);

		$fields['Currency.conversion_padding']['label'] = 'Additional Fee';
		$fields['Currency.conversion_padding']['after'] = '<div class="display-info">This is used when re-calculating foreign prices. You can enter a percentage to add on to the converted price. So for example 5% would be entered as 5.00</div>';

		$fields['Currency.is_default']['after'] = '<div class="display-info">Only one currency should be set to default, and it will be used as the base currency when someone visits your website.</div>';

		return $fields;
	}
}
