<?php
App::uses('AppComponent', 'Controller/Component');

class CurrenciesComponent extends AppComponent {

	public $currencyId = 0;

	public $currency = null;

	// Setting this will be picked up in the startup and the currency change event will be fired
	public $dispatchChangeEventOnStartup = false;

	public function initialize(Controller $controller) {
		parent::initialize($controller);

		$Currencies = EvClassRegistry::init('EvCurrency.Currency');
		$currencyList = $Currencies->getForDropDown(
			array(
				'order' => 'Currency.name ASC'
			)
		);

		// Add to a globally accessible config variable for use in other plugins
		Configure::write('currencies', $currencyList);

		// Add to the controller view for us in select lists
		$this->_controller->set(
			'currencies',
			$currencyList
		);

		if (!CakeSession::read('EvCurrency.currencyId') || empty($currencyList[CakeSession::read('EvCurrency.currencyId')])) {

			// Load default currency
			$currency = $Currencies->find('first', array(
				'conditions' => array(
					'is_default' => 1
				)
			));

			// Change the currency but delay the event until startup
			$this->dispatchChangeEventOnStartup = true;
			$this->setCurrency($currency['Currency']['id'], false);

		} else {
			CakeNumber::defaultCurrency($currencyList[CakeSession::read('EvCurrency.currencyId')]);

			$currency = $Currencies->find('first', array(
				'conditions' => array(
					'id' => CakeSession::read('EvCurrency.currencyId')
				)
			));

			CakeNumber::addFormat($currency['Currency']['name'], array(
				'wholeSymbol' => $currency['Currency']['currency_prefix'],
				'wholePosition' => 'before',
				'fractionSymbol' => false,
				'fractionPosition' => 'after',
				'zero' => 0,
				'places' => $currency['Currency']['decimal_places'],
				'thousands' => $currency['Currency']['thousand_separator'],
				'decimals' => $currency['Currency']['decimal_point_char'],
				'negative' => '()',
				'escape' => false,
				'fractionExponent' => 2,
				'after' => false
			));
		}
	}

	public function startup(Controller $controller) {
		if ($this->dispatchChangeEventOnStartup) {
			$this->dispatchChangeEventOnStartup = false;
			$this->_dispatchChangeEvent();
		}
	}

	/**
	 * run the form injection
	 * For custom fields this add type / validation arrays to the template for fields
	 *
	 * @param   array       Data from $this->request->data
	 * @param   object      Model Object for the primary model we are dealing with
	 * @param   int|null    The ID if on edit or null of add
	 */
	public function injectAdminForm($data, $Model, $id) {
		$Currencies = EvClassRegistry::init('EvCurrency.Currency');

		$this->_controller->set(
			'currencies',
			$Currencies->getForDropDown(
				array(
					'order' => 'Currency.name ASC'
				)
			)
		);
	}

	public function setCurrency($currencyId = null, $dispatchEvent = true) {
		// Because of cake being cake, this component has no access to its parent controller. Amazing.
		// So that means for now this method has to be called manually, passing in the controller.
		// If you know how - fix it.

		// Load the default or active currency
		$Model = EvClassRegistry::init('EvCurrency.Currency');

		$defaultParams = array(
			'conditions' => array(
				'is_default' => 1,
				'is_active' => 1
			)
		);

		$session = false;

		if ($currencyId > 0) {

			$params = array(
				'conditions' => array(
					'id' => $currencyId,
					'is_active' => 1
				)
			);

			$currency = $Model->find('first', $params);
		} else {

			if (CakeSession::read('EvCurrency.currencyId') > 0) {
				$params = array(
					'conditions' => array(
						'id' => CakeSession::read('EvCurrency.currencyId'),
						'is_active' => 1
					)
				);

				$session = true;
			}

			$currency = $Model->find('first', ($session ? $params : $defaultParams));
		}

		if (empty($currency)) {
			// Tried to use a loaded currency that is either inactive or does not exist. Fall back
			// to the default one.
			$currency = $Model->find('first', $defaultParams);

			if (empty($currency)) {
				return false;
			}
		}

		$this->currencyId = $currency['Currency']['id'];
		$this->currency = $currency['Currency'];

		CakeNumber::addFormat($currency['Currency']['name'], array(
			'wholeSymbol' => $currency['Currency']['currency_prefix'],
			'wholePosition' => 'before',
			'fractionSymbol' => false,
			'fractionPosition' => 'after',
			'zero' => 0,
			'places' => $currency['Currency']['decimal_places'],
			'thousands' => $currency['Currency']['thousand_separator'],
			'decimals' => $currency['Currency']['decimal_point_char'],
			'negative' => '()',
			'escape' => false,
			'fractionExponent' => 2,
			'after' => false
		));

		CakeNumber::defaultCurrency($currency['Currency']['name']);

		$this->_controller->set('currency', $this->currency);

		if (! empty($currency) && isset($currency['Currency'])) {
			CakeSession::write('EvCurrency.currencyId', $currency['Currency']['id']);
			CakeSession::write('EvCurrency.currencyCode', $currency['Currency']['name']);
			CakeSession::write('EvCurrency.currencyData', $currency['Currency']);
		}

		if ($dispatchEvent) {
			$this->_dispatchChangeEvent();
		}
	}

/**
 * Sends the currency change event - this should only be sent once all components are loaded to avoid errors
 */
	protected function _dispatchChangeEvent() {
		$this->_controller->getEventManager()->dispatch(
			new CakeEvent('EvCurrency.Component.Currencies.setCurrency', $this, array(
				'currency' => $this->currency,
			))
		);
	}
}
