<?php

App::uses('PluginInstallShell', 'shells');
App::uses('File', 'Utility');

class EvCurrencyInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvNavigation.Menu'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		// run the populate.sql file
		$this->_populateContent(
			ROOT . DS . 'Plugin' . DS . 'EvCurrency' . DS . '_src' . DS . 'database' . DS . 'populate.sql'
		);

		// Add to the admin menu
		$this->Menu->save(
			array(
				'Menu' => array(
					'parent_id' => 1,
					'name' => 'Currencies',
					'pattern' => '/^\/admin\/ev_currency\//',
					'plugin' => 'EvCurrenct',
					'controller' => 'ev_currency.currencies',
					'model' => 'Currency',
					'action' => 'index',
					'class' => 'icon-gbp',
					'is_active' => 1
				)
			)
		);
	}
}

