<?php
/**
 * EvCountryCountry Fixture
 */
class CountryFixture extends CakeTestFixture {

	public $table = 'ev_country_countries';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
		'name' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 45, 'key' => 'unique', 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
		'iso2' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 2, 'key' => 'unique', 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
		'is_eu' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
		'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'name_UNIQUE' => array('column' => 'name', 'unique' => 1),
			'iso2_UNIQUE' => array('column' => 'iso2', 'unique' => 1)
		),
		'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'name' => 'United Kingdom',
			'iso2' => 'GB',
			'is_eu' => 1,
			'sequence' => 1,
			'created' => '2015-09-04 13:41:15',
			'modified' => '2015-09-04 13:41:15'
		),
		array(
			'id' => 2,
			'name' => 'United States',
			'iso2' => 'US',
			'is_eu' => 0,
			'sequence' => 1,
			'created' => '2015-09-04 13:41:15',
			'modified' => '2015-09-04 13:41:15'
		),
		array(
			'id' => 3,
			'name' => 'France',
			'iso2' => 'FR',
			'is_eu' => 1,
			'sequence' => 1,
			'created' => '2015-09-04 13:41:15',
			'modified' => '2015-09-04 13:41:15'
		)
	);

}
