<?php

App::uses('EvCountryAppController', 'EvCountry.Controller');

/**
 * Countries Controller
 *
 * @package EvCountry/Countries
 */
class CountriesController extends EvCountryAppController {

    public $uses = 'EvCountry.Country';

    /**
     * Admin Filter Fields
     *
     * Overrides the EvCoreController method to allow us to filter by EU countries
     *
     * @return array Returns the list of fields to filter by, along with thier specific params
     */
    public function _adminFilterFields() {

        $fields = parent::_adminFilterFields();

        $fields['Country.is_eu'] = array(
            'label' => 'EU Only',
            'type' => 'boolean',
            'compare' => array(
                'Country.is_eu' => '%s'
            )
        );

        return $fields;
    }

}