<?php
App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class AddCrownDependencies extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Add_Crown_dependencies';

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$CountryUtil = MigrationUtil::init('EvCountry.Country');

		if ($direction == 'up') {
			$countries = $this->__countries($CountryUtil->Model);
			foreach ($countries as $country) {
				$previousCountry = $CountryUtil->Model->findByIso2($country['after']);
				if (! empty($previousCountry[$CountryUtil->Model->alias]['sequence'])) {
					$country['sequence'] = $previousCountry[$CountryUtil->Model->alias]['sequence'] + 1;
					$CountryUtil->Model->updateAll(['sequence' => '(sequence + 1)'], ['sequence >=' => $country['sequence']]);
				}
				unset($country['after']);
				$CountryUtil->createOnce(['iso2' => $country['iso2']], $country);
			}

			return true;
		}

		return $CountryUtil->deleteAll(
			[
				$CountryUtil->Model->alias . '.iso2' => Hash::extract(
					$this->__countries($CountryUtil->Model),
					'{n}.iso2'
				),
			]
		);
	}

/**
 * Countries to be added as part of the migration
 *
 * @param Model $Country Countries model
 * @return array
 */
	private function __countries($Country) {
		return [
			['name' => "Guernsey", 'iso2' => "GG", 'is_eu' => false, 'after' => 'GT'],
			['name' => "Isle of Man", 'iso2' => "IM", 'is_eu' => false, 'after' => 'IE'],
			['name' => "Jersey", 'iso2' => "JE", 'is_eu' => false, 'after' => 'JP'],
		];
	}
}
