<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class PopulateCountries extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'populate_countries';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [],
		'down' => [],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$CountryUtil = MigrationUtil::init('EvCountry.Country');

		if ($direction == 'up') {
			return $CountryUtil->createAllOnce(
				[
					'iso2',
				],
				$this->__countries($CountryUtil->Model)
			);
		}

		return $CountryUtil->deleteAll(
			[
				$CountryUtil->Model->alias . '.iso2' => Hash::extract(
					$this->__countries($CountryUtil->Model),
					'{n}.' . $CountryUtil->Model->alias . '.iso2'
				),
			]
		);
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}

/**
 * Array of countries to add/remove.
 *
 * @param obj $Model The country model.
 * @return array.
 */
	private function __countries($Model) {
		return [
			[$Model->alias => ['name' => "Afghanistan", 'iso2' => "AF", 'is_eu' => false, 'sequence' => 1]],
			[$Model->alias => ['name' => "Albania", 'iso2' => "AL", 'is_eu' => false, 'sequence' => 2]],
			[$Model->alias => ['name' => "Algeria", 'iso2' => "DZ", 'is_eu' => false, 'sequence' => 3]],
			[$Model->alias => ['name' => "American Samoa", 'iso2' => "AS", 'is_eu' => false, 'sequence' => 4]],
			[$Model->alias => ['name' => "Andorra", 'iso2' => "AD", 'is_eu' => false, 'sequence' => 5]],
			[$Model->alias => ['name' => "Angola", 'iso2' => "AO", 'is_eu' => false, 'sequence' => 6]],
			[$Model->alias => ['name' => "Anguilla", 'iso2' => "AI", 'is_eu' => false, 'sequence' => 7]],
			[$Model->alias => ['name' => "Antarctica", 'iso2' => "AQ", 'is_eu' => false, 'sequence' => 8]],
			[$Model->alias => ['name' => "Antigua and Barbuda", 'iso2' => "AG", 'is_eu' => false, 'sequence' => 9]],
			[$Model->alias => ['name' => "Argentina", 'iso2' => "AR", 'is_eu' => false, 'sequence' => 10]],
			[$Model->alias => ['name' => "Armenia", 'iso2' => "AM", 'is_eu' => false, 'sequence' => 11]],
			[$Model->alias => ['name' => "Aruba", 'iso2' => "AW", 'is_eu' => false, 'sequence' => 12]],
			[$Model->alias => ['name' => "Australia", 'iso2' => "AU", 'is_eu' => false, 'sequence' => 13]],
			[$Model->alias => ['name' => "Austria", 'iso2' => "AT", 'is_eu' => true, 'sequence' => 14]],
			[$Model->alias => ['name' => "Azerbaijan", 'iso2' => "AZ", 'is_eu' => false, 'sequence' => 15]],
			[$Model->alias => ['name' => "Bahamas", 'iso2' => "BS", 'is_eu' => false, 'sequence' => 16]],
			[$Model->alias => ['name' => "Bahrain", 'iso2' => "BH", 'is_eu' => false, 'sequence' => 17]],
			[$Model->alias => ['name' => "Bangladesh", 'iso2' => "BD", 'is_eu' => false, 'sequence' => 18]],
			[$Model->alias => ['name' => "Barbados", 'iso2' => "BB", 'is_eu' => false, 'sequence' => 19]],
			[$Model->alias => ['name' => "Belarus", 'iso2' => "BY", 'is_eu' => false, 'sequence' => 20]],
			[$Model->alias => ['name' => "Belgium", 'iso2' => "BE", 'is_eu' => true, 'sequence' => 21]],
			[$Model->alias => ['name' => "Belize", 'iso2' => "BZ", 'is_eu' => false, 'sequence' => 22]],
			[$Model->alias => ['name' => "Benin", 'iso2' => "BJ", 'is_eu' => false, 'sequence' => 23]],
			[$Model->alias => ['name' => "Bermuda", 'iso2' => "BM", 'is_eu' => false, 'sequence' => 24]],
			[$Model->alias => ['name' => "Bhutan", 'iso2' => "BT", 'is_eu' => false, 'sequence' => 25]],
			[$Model->alias => ['name' => "Bolivia", 'iso2' => "BO", 'is_eu' => false, 'sequence' => 26]],
			[$Model->alias => ['name' => "Bosnia and Herzegovina", 'iso2' => "BA", 'is_eu' => false, 'sequence' => 27]],
			[$Model->alias => ['name' => "Botswana", 'iso2' => "BW", 'is_eu' => false, 'sequence' => 28]],
			[$Model->alias => ['name' => "Bouvet Island", 'iso2' => "BV", 'is_eu' => false, 'sequence' => 29]],
			[$Model->alias => ['name' => "Brazil", 'iso2' => "BR", 'is_eu' => false, 'sequence' => 30]],
			[$Model->alias => ['name' => "British Indian Ocean Territory", 'iso2' => "IO", 'is_eu' => false, 'sequence' => 31]],
			[$Model->alias => ['name' => "Brunei Darussalam", 'iso2' => "BN", 'is_eu' => false, 'sequence' => 32]],
			[$Model->alias => ['name' => "Bulgaria", 'iso2' => "BG", 'is_eu' => true, 'sequence' => 33]],
			[$Model->alias => ['name' => "Burkina Faso", 'iso2' => "BF", 'is_eu' => false, 'sequence' => 34]],
			[$Model->alias => ['name' => "Burundi", 'iso2' => "BI", 'is_eu' => false, 'sequence' => 35]],
			[$Model->alias => ['name' => "Cambodia", 'iso2' => "KH", 'is_eu' => false, 'sequence' => 36]],
			[$Model->alias => ['name' => "Cameroon", 'iso2' => "CM", 'is_eu' => false, 'sequence' => 37]],
			[$Model->alias => ['name' => "Canada", 'iso2' => "CA", 'is_eu' => false, 'sequence' => 38]],
			[$Model->alias => ['name' => "Cape Verde", 'iso2' => "CV", 'is_eu' => false, 'sequence' => 39]],
			[$Model->alias => ['name' => "Cayman Islands", 'iso2' => "KY", 'is_eu' => false, 'sequence' => 40]],
			[$Model->alias => ['name' => "Central African Republic", 'iso2' => "CF", 'is_eu' => false, 'sequence' => 41]],
			[$Model->alias => ['name' => "Chad", 'iso2' => "TD", 'is_eu' => false, 'sequence' => 42]],
			[$Model->alias => ['name' => "Chile", 'iso2' => "CL", 'is_eu' => false, 'sequence' => 43]],
			[$Model->alias => ['name' => "China", 'iso2' => "CN", 'is_eu' => false, 'sequence' => 44]],
			[$Model->alias => ['name' => "Christmas Island", 'iso2' => "CX", 'is_eu' => false, 'sequence' => 45]],
			[$Model->alias => ['name' => "Cocos (Keeling) Islands", 'iso2' => "CC", 'is_eu' => false, 'sequence' => 46]],
			[$Model->alias => ['name' => "Colombia", 'iso2' => "CO", 'is_eu' => false, 'sequence' => 47]],
			[$Model->alias => ['name' => "Comoros", 'iso2' => "KM", 'is_eu' => false, 'sequence' => 48]],
			[$Model->alias => ['name' => "Congo", 'iso2' => "CG", 'is_eu' => false, 'sequence' => 49]],
			[$Model->alias => ['name' => "Congo,  the Democratic Republic of the", 'iso2' => "CD", 'is_eu' => false, 'sequence' => 50]],
			[$Model->alias => ['name' => "Cook Islands", 'iso2' => "CK", 'is_eu' => false, 'sequence' => 51]],
			[$Model->alias => ['name' => "Costa Rica", 'iso2' => "CR", 'is_eu' => false, 'sequence' => 52]],
			[$Model->alias => ['name' => "Cote D'Ivoire", 'iso2' => "CI", 'is_eu' => false, 'sequence' => 53]],
			[$Model->alias => ['name' => "Croatia", 'iso2' => "HR", 'is_eu' => true, 'sequence' => 54]],
			[$Model->alias => ['name' => "Cuba", 'iso2' => "CU", 'is_eu' => false, 'sequence' => 55]],
			[$Model->alias => ['name' => "Czech Republic", 'iso2' => "CZ", 'is_eu' => true, 'sequence' => 57]],
			[$Model->alias => ['name' => "Denmark", 'iso2' => "DK", 'is_eu' => true, 'sequence' => 58]],
			[$Model->alias => ['name' => "Djibouti", 'iso2' => "DJ", 'is_eu' => false, 'sequence' => 59]],
			[$Model->alias => ['name' => "Dominica", 'iso2' => "DM", 'is_eu' => false, 'sequence' => 60]],
			[$Model->alias => ['name' => "Dominican Republic", 'iso2' => "DO", 'is_eu' => false, 'sequence' => 61]],
			[$Model->alias => ['name' => "Ecuador", 'iso2' => "EC", 'is_eu' => false, 'sequence' => 62]],
			[$Model->alias => ['name' => "Egypt", 'iso2' => "EG", 'is_eu' => false, 'sequence' => 63]],
			[$Model->alias => ['name' => "El Salvador", 'iso2' => "SV", 'is_eu' => false, 'sequence' => 64]],
			[$Model->alias => ['name' => "Equatorial Guinea", 'iso2' => "GQ", 'is_eu' => false, 'sequence' => 65]],
			[$Model->alias => ['name' => "Eritrea", 'iso2' => "ER", 'is_eu' => false, 'sequence' => 66]],
			[$Model->alias => ['name' => "Estonia", 'iso2' => "EE", 'is_eu' => true, 'sequence' => 67]],
			[$Model->alias => ['name' => "Ethiopia", 'iso2' => "ET", 'is_eu' => false, 'sequence' => 68]],
			[$Model->alias => ['name' => "European Union", 'iso2' => "eu", 'is_eu' => false, 'sequence' => 240]],
			[$Model->alias => ['name' => "Falkland Islands (Malvinas)", 'iso2' => "FK", 'is_eu' => false, 'sequence' => 69]],
			[$Model->alias => ['name' => "Faroe Islands", 'iso2' => "FO", 'is_eu' => false, 'sequence' => 70]],
			[$Model->alias => ['name' => "Fiji", 'iso2' => "FJ", 'is_eu' => false, 'sequence' => 71]],
			[$Model->alias => ['name' => "Finland", 'iso2' => "FI", 'is_eu' => true, 'sequence' => 72]],
			[$Model->alias => ['name' => "France", 'iso2' => "FR", 'is_eu' => true, 'sequence' => 73]],
			[$Model->alias => ['name' => "French Guiana", 'iso2' => "GF", 'is_eu' => false, 'sequence' => 74]],
			[$Model->alias => ['name' => "French Polynesia", 'iso2' => "PF", 'is_eu' => false, 'sequence' => 75]],
			[$Model->alias => ['name' => "French Southern Territories", 'iso2' => "TF", 'is_eu' => false, 'sequence' => 76]],
			[$Model->alias => ['name' => "Gabon", 'iso2' => "GA", 'is_eu' => false, 'sequence' => 77]],
			[$Model->alias => ['name' => "Gambia", 'iso2' => "GM", 'is_eu' => false, 'sequence' => 78]],
			[$Model->alias => ['name' => "General", 'iso2' => "WW", 'is_eu' => false, 'sequence' => 241]],
			[$Model->alias => ['name' => "Georgia", 'iso2' => "GE", 'is_eu' => false, 'sequence' => 79]],
			[$Model->alias => ['name' => "Germany", 'iso2' => "DE", 'is_eu' => true, 'sequence' => 80]],
			[$Model->alias => ['name' => "Ghana", 'iso2' => "GH", 'is_eu' => false, 'sequence' => 81]],
			[$Model->alias => ['name' => "Gibraltar", 'iso2' => "GI", 'is_eu' => false, 'sequence' => 82]],
			[$Model->alias => ['name' => "Greece", 'iso2' => "GR", 'is_eu' => true, 'sequence' => 83]],
			[$Model->alias => ['name' => "Greenland", 'iso2' => "GL", 'is_eu' => false, 'sequence' => 84]],
			[$Model->alias => ['name' => "Grenada", 'iso2' => "GD", 'is_eu' => false, 'sequence' => 85]],
			[$Model->alias => ['name' => "Guadeloupe", 'iso2' => "GP", 'is_eu' => false, 'sequence' => 86]],
			[$Model->alias => ['name' => "Guam", 'iso2' => "GU", 'is_eu' => false, 'sequence' => 87]],
			[$Model->alias => ['name' => "Guatemala", 'iso2' => "GT", 'is_eu' => false, 'sequence' => 88]],
			[$Model->alias => ['name' => "Guinea", 'iso2' => "GN", 'is_eu' => false, 'sequence' => 89]],
			[$Model->alias => ['name' => "Guinea-Bissau", 'iso2' => "GW", 'is_eu' => false, 'sequence' => 90]],
			[$Model->alias => ['name' => "Guyana", 'iso2' => "GY", 'is_eu' => false, 'sequence' => 91]],
			[$Model->alias => ['name' => "Haiti", 'iso2' => "HT", 'is_eu' => false, 'sequence' => 92]],
			[$Model->alias => ['name' => "Heard Island and Mcdonald Islands", 'iso2' => "HM", 'is_eu' => false, 'sequence' => 93]],
			[$Model->alias => ['name' => "Holy See (Vatican City State)", 'iso2' => "VA", 'is_eu' => false, 'sequence' => 94]],
			[$Model->alias => ['name' => "Honduras", 'iso2' => "HN", 'is_eu' => false, 'sequence' => 95]],
			[$Model->alias => ['name' => "Hong Kong", 'iso2' => "HK", 'is_eu' => false, 'sequence' => 96]],
			[$Model->alias => ['name' => "Hungary", 'iso2' => "HU", 'is_eu' => true, 'sequence' => 97]],
			[$Model->alias => ['name' => "Iceland", 'iso2' => "IS", 'is_eu' => false, 'sequence' => 98]],
			[$Model->alias => ['name' => "India", 'iso2' => "IN", 'is_eu' => false, 'sequence' => 99]],
			[$Model->alias => ['name' => "Indonesia", 'iso2' => "ID", 'is_eu' => false, 'sequence' => 100]],
			[$Model->alias => ['name' => "Iran,  Islamic Republic of", 'iso2' => "IR", 'is_eu' => false, 'sequence' => 101]],
			[$Model->alias => ['name' => "Iraq", 'iso2' => "IQ", 'is_eu' => false, 'sequence' => 102]],
			[$Model->alias => ['name' => "Ireland", 'iso2' => "IE", 'is_eu' => true, 'sequence' => 103]],
			[$Model->alias => ['name' => "Israel", 'iso2' => "IL", 'is_eu' => false, 'sequence' => 104]],
			[$Model->alias => ['name' => "Italy", 'iso2' => "IT", 'is_eu' => true, 'sequence' => 105]],
			[$Model->alias => ['name' => "Jamaica", 'iso2' => "JM", 'is_eu' => false, 'sequence' => 106]],
			[$Model->alias => ['name' => "Japan", 'iso2' => "JP", 'is_eu' => false, 'sequence' => 107]],
			[$Model->alias => ['name' => "Jordan", 'iso2' => "JO", 'is_eu' => false, 'sequence' => 108]],
			[$Model->alias => ['name' => "Kazakhstan", 'iso2' => "KZ", 'is_eu' => false, 'sequence' => 109]],
			[$Model->alias => ['name' => "Kenya", 'iso2' => "KE", 'is_eu' => false, 'sequence' => 110]],
			[$Model->alias => ['name' => "Kiribati", 'iso2' => "KI", 'is_eu' => false, 'sequence' => 111]],
			[$Model->alias => ['name' => "Korea,  Democratic People's Republic of", 'iso2' => "KP", 'is_eu' => false, 'sequence' => 112]],
			[$Model->alias => ['name' => "Korea,  Republic of", 'iso2' => "KR", 'is_eu' => false, 'sequence' => 113]],
			[$Model->alias => ['name' => "Kuwait", 'iso2' => "KW", 'is_eu' => false, 'sequence' => 114]],
			[$Model->alias => ['name' => "Kyrgyzstan", 'iso2' => "KG", 'is_eu' => false, 'sequence' => 115]],
			[$Model->alias => ['name' => "Lao People's Democratic Republic", 'iso2' => "LA", 'is_eu' => false, 'sequence' => 116]],
			[$Model->alias => ['name' => "Latvia", 'iso2' => "LV", 'is_eu' => true, 'sequence' => 117]],
			[$Model->alias => ['name' => "Lebanon", 'iso2' => "LB", 'is_eu' => false, 'sequence' => 118]],
			[$Model->alias => ['name' => "Lesotho", 'iso2' => "LS", 'is_eu' => false, 'sequence' => 119]],
			[$Model->alias => ['name' => "Liberia", 'iso2' => "LR", 'is_eu' => false, 'sequence' => 120]],
			[$Model->alias => ['name' => "Libyan Arab Jamahiriya", 'iso2' => "LY", 'is_eu' => false, 'sequence' => 121]],
			[$Model->alias => ['name' => "Liechtenstein", 'iso2' => "LI", 'is_eu' => false, 'sequence' => 122]],
			[$Model->alias => ['name' => "Lithuania", 'iso2' => "LT", 'is_eu' => true, 'sequence' => 123]],
			[$Model->alias => ['name' => "Luxembourg", 'iso2' => "LU", 'is_eu' => true, 'sequence' => 124]],
			[$Model->alias => ['name' => "Macao", 'iso2' => "MO", 'is_eu' => false, 'sequence' => 125]],
			[$Model->alias => ['name' => "Macedonia,  the Former Yugoslav Republic of", 'iso2' => "MK", 'is_eu' => false, 'sequence' => 126]],
			[$Model->alias => ['name' => "Madagascar", 'iso2' => "MG", 'is_eu' => false, 'sequence' => 127]],
			[$Model->alias => ['name' => "Malawi", 'iso2' => "MW", 'is_eu' => false, 'sequence' => 128]],
			[$Model->alias => ['name' => "Malaysia", 'iso2' => "MY", 'is_eu' => false, 'sequence' => 129]],
			[$Model->alias => ['name' => "Maldives", 'iso2' => "MV", 'is_eu' => false, 'sequence' => 130]],
			[$Model->alias => ['name' => "Mali", 'iso2' => "ML", 'is_eu' => false, 'sequence' => 131]],
			[$Model->alias => ['name' => "Malta", 'iso2' => "MT", 'is_eu' => true, 'sequence' => 132]],
			[$Model->alias => ['name' => "Marshall Islands", 'iso2' => "MH", 'is_eu' => false, 'sequence' => 133]],
			[$Model->alias => ['name' => "Martinique", 'iso2' => "MQ", 'is_eu' => false, 'sequence' => 134]],
			[$Model->alias => ['name' => "Mauritania", 'iso2' => "MR", 'is_eu' => false, 'sequence' => 135]],
			[$Model->alias => ['name' => "Mauritius", 'iso2' => "MU", 'is_eu' => false, 'sequence' => 136]],
			[$Model->alias => ['name' => "Mayotte", 'iso2' => "YT", 'is_eu' => false, 'sequence' => 137]],
			[$Model->alias => ['name' => "Mexico", 'iso2' => "MX", 'is_eu' => false, 'sequence' => 138]],
			[$Model->alias => ['name' => "Micronesia,  Federated States of", 'iso2' => "FM", 'is_eu' => false, 'sequence' => 139]],
			[$Model->alias => ['name' => "Moldova,  Republic of", 'iso2' => "MD", 'is_eu' => false, 'sequence' => 140]],
			[$Model->alias => ['name' => "Monaco", 'iso2' => "MC", 'is_eu' => false, 'sequence' => 141]],
			[$Model->alias => ['name' => "Mongolia", 'iso2' => "MN", 'is_eu' => false, 'sequence' => 142]],
			[$Model->alias => ['name' => "Montserrat", 'iso2' => "MS", 'is_eu' => false, 'sequence' => 143]],
			[$Model->alias => ['name' => "Morocco", 'iso2' => "MA", 'is_eu' => false, 'sequence' => 144]],
			[$Model->alias => ['name' => "Mozambique", 'iso2' => "MZ", 'is_eu' => false, 'sequence' => 145]],
			[$Model->alias => ['name' => "Myanmar", 'iso2' => "MM", 'is_eu' => false, 'sequence' => 146]],
			[$Model->alias => ['name' => "Namibia", 'iso2' => "NA", 'is_eu' => false, 'sequence' => 147]],
			[$Model->alias => ['name' => "Nauru", 'iso2' => "NR", 'is_eu' => false, 'sequence' => 148]],
			[$Model->alias => ['name' => "Nepal", 'iso2' => "NP", 'is_eu' => false, 'sequence' => 149]],
			[$Model->alias => ['name' => "Netherlands", 'iso2' => "NL", 'is_eu' => true, 'sequence' => 150]],
			[$Model->alias => ['name' => "New Caledonia", 'iso2' => "NC", 'is_eu' => false, 'sequence' => 152]],
			[$Model->alias => ['name' => "New Zealand", 'iso2' => "NZ", 'is_eu' => false, 'sequence' => 153]],
			[$Model->alias => ['name' => "Nicaragua", 'iso2' => "NI", 'is_eu' => false, 'sequence' => 154]],
			[$Model->alias => ['name' => "Niger", 'iso2' => "NE", 'is_eu' => false, 'sequence' => 155]],
			[$Model->alias => ['name' => "Nigeria", 'iso2' => "NG", 'is_eu' => false, 'sequence' => 156]],
			[$Model->alias => ['name' => "Niue", 'iso2' => "NU", 'is_eu' => false, 'sequence' => 157]],
			[$Model->alias => ['name' => "Norfolk Island", 'iso2' => "NF", 'is_eu' => false, 'sequence' => 158]],
			[$Model->alias => ['name' => "Northern Mariana Islands", 'iso2' => "MP", 'is_eu' => false, 'sequence' => 159]],
			[$Model->alias => ['name' => "Norway", 'iso2' => "NO", 'is_eu' => false, 'sequence' => 160]],
			[$Model->alias => ['name' => "Oman", 'iso2' => "OM", 'is_eu' => false, 'sequence' => 161]],
			[$Model->alias => ['name' => "Pakistan", 'iso2' => "PK", 'is_eu' => false, 'sequence' => 162]],
			[$Model->alias => ['name' => "Palau", 'iso2' => "PW", 'is_eu' => false, 'sequence' => 163]],
			[$Model->alias => ['name' => "Palestinian Territory,  Occupied", 'iso2' => "PS", 'is_eu' => false, 'sequence' => 164]],
			[$Model->alias => ['name' => "Panama", 'iso2' => "PA", 'is_eu' => false, 'sequence' => 165]],
			[$Model->alias => ['name' => "Papua New Guinea", 'iso2' => "PG", 'is_eu' => false, 'sequence' => 166]],
			[$Model->alias => ['name' => "Paraguay", 'iso2' => "PY", 'is_eu' => false, 'sequence' => 167]],
			[$Model->alias => ['name' => "Peru", 'iso2' => "PE", 'is_eu' => false, 'sequence' => 168]],
			[$Model->alias => ['name' => "Philippines", 'iso2' => "PH", 'is_eu' => false, 'sequence' => 169]],
			[$Model->alias => ['name' => "Pitcairn", 'iso2' => "PN", 'is_eu' => false, 'sequence' => 170]],
			[$Model->alias => ['name' => "Poland", 'iso2' => "PL", 'is_eu' => true, 'sequence' => 171]],
			[$Model->alias => ['name' => "Portugal", 'iso2' => "PT", 'is_eu' => true, 'sequence' => 172]],
			[$Model->alias => ['name' => "Puerto Rico", 'iso2' => "PR", 'is_eu' => false, 'sequence' => 173]],
			[$Model->alias => ['name' => "Qatar", 'iso2' => "QA", 'is_eu' => false, 'sequence' => 174]],
			[$Model->alias => ['name' => "Republic of Cyprus", 'iso2' => "CY", 'is_eu' => true, 'sequence' => 56]],
			[$Model->alias => ['name' => "Reunion", 'iso2' => "RE", 'is_eu' => false, 'sequence' => 175]],
			[$Model->alias => ['name' => "Romania", 'iso2' => "RO", 'is_eu' => true, 'sequence' => 176]],
			[$Model->alias => ['name' => "Russian Federation", 'iso2' => "RU", 'is_eu' => false, 'sequence' => 177]],
			[$Model->alias => ['name' => "Rwanda", 'iso2' => "RW", 'is_eu' => false, 'sequence' => 178]],
			[$Model->alias => ['name' => "Saint Helena", 'iso2' => "SH", 'is_eu' => false, 'sequence' => 179]],
			[$Model->alias => ['name' => "Saint Kitts and Nevis", 'iso2' => "KN", 'is_eu' => false, 'sequence' => 180]],
			[$Model->alias => ['name' => "Saint Lucia", 'iso2' => "LC", 'is_eu' => false, 'sequence' => 181]],
			[$Model->alias => ['name' => "Saint Pierre and Miquelon", 'iso2' => "PM", 'is_eu' => false, 'sequence' => 182]],
			[$Model->alias => ['name' => "Saint Vincent and the Grenadines", 'iso2' => "VC", 'is_eu' => false, 'sequence' => 183]],
			[$Model->alias => ['name' => "Samoa", 'iso2' => "WS", 'is_eu' => false, 'sequence' => 184]],
			[$Model->alias => ['name' => "San Marino", 'iso2' => "SM", 'is_eu' => false, 'sequence' => 185]],
			[$Model->alias => ['name' => "Sao Tome and Principe", 'iso2' => "ST", 'is_eu' => false, 'sequence' => 186]],
			[$Model->alias => ['name' => "Saudi Arabia", 'iso2' => "SA", 'is_eu' => false, 'sequence' => 187]],
			[$Model->alias => ['name' => "Senegal", 'iso2' => "SN", 'is_eu' => false, 'sequence' => 188]],
			[$Model->alias => ['name' => "Serbia and Montenegro", 'iso2' => "CS", 'is_eu' => false, 'sequence' => 189]],
			[$Model->alias => ['name' => "Seychelles", 'iso2' => "SC", 'is_eu' => false, 'sequence' => 190]],
			[$Model->alias => ['name' => "Sierra Leone", 'iso2' => "SL", 'is_eu' => false, 'sequence' => 191]],
			[$Model->alias => ['name' => "Singapore", 'iso2' => "SG", 'is_eu' => false, 'sequence' => 192]],
			[$Model->alias => ['name' => "Slovakia", 'iso2' => "SK", 'is_eu' => true, 'sequence' => 193]],
			[$Model->alias => ['name' => "Slovenia", 'iso2' => "SI", 'is_eu' => true, 'sequence' => 194]],
			[$Model->alias => ['name' => "Solomon Islands", 'iso2' => "SB", 'is_eu' => false, 'sequence' => 195]],
			[$Model->alias => ['name' => "Somalia", 'iso2' => "SO", 'is_eu' => false, 'sequence' => 196]],
			[$Model->alias => ['name' => "South Africa", 'iso2' => "ZA", 'is_eu' => false, 'sequence' => 197]],
			[$Model->alias => ['name' => "South Georgia and the South Sandwich Islands", 'iso2' => "GS", 'is_eu' => false, 'sequence' => 198]],
			[$Model->alias => ['name' => "Spain", 'iso2' => "ES", 'is_eu' => true, 'sequence' => 199]],
			[$Model->alias => ['name' => "Sri Lanka", 'iso2' => "LK", 'is_eu' => false, 'sequence' => 200]],
			[$Model->alias => ['name' => "Sudan", 'iso2' => "SD", 'is_eu' => false, 'sequence' => 201]],
			[$Model->alias => ['name' => "Suriname", 'iso2' => "SR", 'is_eu' => false, 'sequence' => 202]],
			[$Model->alias => ['name' => "Svalbard and Jan Mayen", 'iso2' => "SJ", 'is_eu' => false, 'sequence' => 203]],
			[$Model->alias => ['name' => "Swaziland", 'iso2' => "SZ", 'is_eu' => false, 'sequence' => 204]],
			[$Model->alias => ['name' => "Sweden", 'iso2' => "SE", 'is_eu' => true, 'sequence' => 205]],
			[$Model->alias => ['name' => "Switzerland", 'iso2' => "CH", 'is_eu' => false, 'sequence' => 206]],
			[$Model->alias => ['name' => "Syrian Arab Republic", 'iso2' => "SY", 'is_eu' => false, 'sequence' => 207]],
			[$Model->alias => ['name' => "Taiwan,  Province of China", 'iso2' => "TW", 'is_eu' => false, 'sequence' => 208]],
			[$Model->alias => ['name' => "Tajikistan", 'iso2' => "TJ", 'is_eu' => false, 'sequence' => 209]],
			[$Model->alias => ['name' => "Tanzania,  United Republic of", 'iso2' => "TZ", 'is_eu' => false, 'sequence' => 210]],
			[$Model->alias => ['name' => "Thailand", 'iso2' => "TH", 'is_eu' => false, 'sequence' => 211]],
			[$Model->alias => ['name' => "Timor-Leste", 'iso2' => "TL", 'is_eu' => false, 'sequence' => 212]],
			[$Model->alias => ['name' => "Togo", 'iso2' => "TG", 'is_eu' => false, 'sequence' => 213]],
			[$Model->alias => ['name' => "Tokelau", 'iso2' => "TK", 'is_eu' => false, 'sequence' => 214]],
			[$Model->alias => ['name' => "Tonga", 'iso2' => "TO", 'is_eu' => false, 'sequence' => 215]],
			[$Model->alias => ['name' => "Trinidad and Tobago", 'iso2' => "TT", 'is_eu' => false, 'sequence' => 216]],
			[$Model->alias => ['name' => "Tunisia", 'iso2' => "TN", 'is_eu' => false, 'sequence' => 217]],
			[$Model->alias => ['name' => "Turkey", 'iso2' => "TR", 'is_eu' => false, 'sequence' => 218]],
			[$Model->alias => ['name' => "Turkmenistan", 'iso2' => "TM", 'is_eu' => false, 'sequence' => 219]],
			[$Model->alias => ['name' => "Turks and Caicos Islands", 'iso2' => "TC", 'is_eu' => false, 'sequence' => 220]],
			[$Model->alias => ['name' => "Tuvalu", 'iso2' => "TV", 'is_eu' => false, 'sequence' => 221]],
			[$Model->alias => ['name' => "Uganda", 'iso2' => "UG", 'is_eu' => false, 'sequence' => 222]],
			[$Model->alias => ['name' => "Ukraine", 'iso2' => "UA", 'is_eu' => false, 'sequence' => 223]],
			[$Model->alias => ['name' => "United Arab Emirates", 'iso2' => "AE", 'is_eu' => false, 'sequence' => 224]],
			[$Model->alias => ['name' => "United Kingdom - Channel Islands", 'iso2' => "GC", 'is_eu' => false, 'sequence' => 226]],
			[$Model->alias => ['name' => "United Kingdom", 'iso2' => "GB", 'is_eu' => true, 'sequence' => 225]],
			[$Model->alias => ['name' => "United States Minor Outlying Islands", 'iso2' => "UM", 'is_eu' => false, 'sequence' => 226]],
			[$Model->alias => ['name' => "United States", 'iso2' => "US", 'is_eu' => false, 'sequence' => 227]],
			[$Model->alias => ['name' => "Uruguay", 'iso2' => "UY", 'is_eu' => false, 'sequence' => 228]],
			[$Model->alias => ['name' => "Uzbekistan", 'iso2' => "UZ", 'is_eu' => false, 'sequence' => 229]],
			[$Model->alias => ['name' => "Vanuatu", 'iso2' => "VU", 'is_eu' => false, 'sequence' => 230]],
			[$Model->alias => ['name' => "Venezuela", 'iso2' => "VE", 'is_eu' => false, 'sequence' => 231]],
			[$Model->alias => ['name' => "Viet Nam", 'iso2' => "VN", 'is_eu' => false, 'sequence' => 232]],
			[$Model->alias => ['name' => "Virgin Islands,  British", 'iso2' => "VG", 'is_eu' => false, 'sequence' => 233]],
			[$Model->alias => ['name' => "Virgin Islands,  U.s.", 'iso2' => "VI", 'is_eu' => false, 'sequence' => 234]],
			[$Model->alias => ['name' => "Wallis and Futuna", 'iso2' => "WF", 'is_eu' => false, 'sequence' => 235]],
			[$Model->alias => ['name' => "Western Sahara", 'iso2' => "EH", 'is_eu' => false, 'sequence' => 236]],
			[$Model->alias => ['name' => "Yemen", 'iso2' => "YE", 'is_eu' => false, 'sequence' => 237]],
			[$Model->alias => ['name' => "Zambia", 'iso2' => "ZM", 'is_eu' => false, 'sequence' => 238]],
			[$Model->alias => ['name' => "Zimbabwe", 'iso2' => "ZW", 'is_eu' => false, 'sequence' => 239]],
		];
	}
}
