(function(ev, $, undefined) {
	'use strict';
	ev.cloneable = {};

	var plugin;
	var settings = {
		container: '[data-cloneable-container]',
		row: '[data-cloneable-row]',
		addButton: '[data-cloneable-add]',
		removeButton: '[data-cloneable-remove]',
		idField: '[data-cloneable-id-field]',
		removedIdList: '[data-cloneable-removed-ids]',
		itemLimit: 'data-cloneable-item-limit',
		nameIncrementRegex: 'data-cloneable-increment-regex',
		constFlag: 'data-cloneable-const',
		confirmDeleteFlag: 'data-cloneable-confirm-delete'
	};

	ev.cloneable.init = function() {
		plugin = this;

		if ($(settings.container)) {
			$(settings.container).each(function() {

				var container = $(this);

				plugin.bindAdd(container);

				$(settings.row, container).each( function() {
					plugin.bindRowControls($(this));
				});

				plugin.updateAddButtonActive(container);

			});
		}
	}

	ev.cloneable.bindAdd = function(container) {
		var addButton = $(settings.addButton, container);
		addButton.on('click', function(e) {
			e.preventDefault();
			if (!plugin.reachedItemLimit(container)) {
				plugin.addRow(container);
			}
		})
	}

	ev.cloneable.addRow = function(container) {
		var cloneRow = $(settings.row, container).last();

		if (cloneRow.hasClass('hidden')) {
			// If all attributes have been removed and the last one was hidden
			cloneRow.removeClass('hidden');
		} else {
			// Otherwise add a new one
			var newClone = cloneRow.clone();
			cloneRow.after(newClone);
			plugin.clearValues(newClone, true);
			this.bindRowControls(newClone);

		}

		plugin.updateAddButtonActive(container);
		container.trigger('RowAdded');
	}

	ev.cloneable.removeRow = function(row) {

		var container = row.closest(settings.container);

		const deleteConfirmed = (container.attr(settings.confirmDeleteFlag) === undefined) || confirm('Are you sure you want to remove this item?');
		if (!deleteConfirmed) {
			return;
		}

		// Add the removed id to the list if it is not a new field
		var id = $(settings.idField, row).val();
		if (id) {
			var idList = $(settings.removedIdList, container);
			idList.val( idList.val() + ',' + id );
		}

		if ($(settings.row, container).length <= 1) {
			// Don't delete the last one, just hide it.
			row.addClass('hidden');
			plugin.clearValues(row, false);
		} else {
			row.remove();
		}

		plugin.updateAddButtonActive(container);
		container.trigger('RowRemoved');
	}

	ev.cloneable.bindRowControls = function(row) {
		$(settings.removeButton, row).on('click', function(e) {
			e.preventDefault();
			plugin.removeRow(row);
		});
	}

	ev.cloneable.clearValues = function(row, refreshId) {
		var $container = row.closest(settings.container);
		var pattern = $container.attr(settings.nameIncrementRegex);

		if (pattern == undefined) {
			// Default to the first numeric index
			pattern = /\[([0-9]+)\]/;
		} else {
			pattern = new RegExp(pattern);
		}

		row.find("input, select, textarea").each( function() {
			// Clear any old values
			if (!this.getAttribute(settings.constFlag)) {
				if (this.type == "checkbox" || this.type == "radio") {
					this.checked = false;
				} else {
					this.value = "";
				}
			}

			// Set up the new key by adding one to the index found by the regex
			if (refreshId) {
				this.name = this.name.replace(pattern, function(match, key) {
					return '[' + (parseInt(key) + 1) + ']';
				});
			}
		});
	}

	ev.cloneable.updateAddButtonActive = function (container) {
		const $addButton = container.find(settings.addButton);
		if (plugin.reachedItemLimit(container)) {
			$addButton.addClass('hidden');
		} else {
			$addButton.removeClass('hidden');
		}
	}

	ev.cloneable.reachedItemLimit = function (container) {
		const limit = container.attr(settings.itemLimit);

		if (limit > 0) {
			const count = container.find(settings.row + ':not(.hidden)').length;
			return count >= limit;
		}

		return false;
	}

}(window.ev = window.ev || {}, jQuery));

ev.cloneable.init();
