<div class='edit-form'>
	<div class='edit-form__header'>
		<h1 class='title'><?php echo $this->InflectorExt->camelToPluralize($displayName); ?> <span>Administration</span></h1>
		<h2 class='title edit-form__title'>
			<?php
				echo $actionLabel . ' ';
				echo $this->InflectorExt->camelToHumanize($displayName);
			?>
		</h2>

		<?php echo $this->Element('toolbar'); ?>
		<div class="tab-container"></div>
	</div>

	<?php

		echo $this->Html->script(
			array(
				'admin_form',
				'attachments',
				'tinymce/js/tinymce/tinymce.min',
				'map_location'
			),
			array('inline'=>false)
		);

		echo $this->Form->create($primaryModel, array(
			'inputDefaults' => array(
				'empty' => '',
				'div' => 'form-group',
				'label' => array(
					'class' => 'col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label'
				),
				'class' => 'form-control',
				'wrapInput' => 'col-xs-12 col-sm-10 col-md-9 col-lg-10',
			),
			'type' => 'file',
			'class' => 'form-horizontal'
		));

			// cache the form field tabs to use later
			if (! empty($fields['tabs'])):
				$formFieldTabs = $fields['tabs'];
			endif;

			// remove any reference to the fields tabs
			unset($fields['tabs']);

			$content = $this->fetch('content');
			if (empty($content)):
				$content = '<div class="container-fluid">';
					$content .= $this->element('Forms/fields', array('fields' => $fields));
				$content .='</div>';
			endif;

			echo $this->element(
				'form_tab',
				array(
					'title' => __('Content'),
					'tabContent' => $content,
	                'divOptions' => array(
	                    'class' => 'field-data',
                        'data-active-model' => $activeItem['model'],
                    	'data-active-model-id' => $activeItem['id']
	                )
				)
			);

			// loop around the form field tabs and append to the template
			if (! empty($formFieldTabs)):
				foreach ($formFieldTabs as $tabName => $tabFields):
					$tabContent = '<div class="container-fluid">';

					$tabContent .= $this->element('Forms/fields', [
						'fields' => $tabFields
					]);

					$tabContent .='</div>';

					echo $this->element(
						'form_tab',
						array(
							'title' => __($tabName),
							'tabContent' => $tabContent,
			                'divOptions' => array(
			                    'class' => 'field-data',
		                        'data-active-model' => $activeItem['model'],
		                    	'data-active-model-id' => $activeItem['id']
			                )
						)
					);
				endforeach;
			endif;

			// check to toInject array to see if there are any helpers tp run
			if (! empty($toInjectData['helpers'])):

				foreach ($toInjectData['helpers'] as $class => $helper):

					echo $this->{$class}->injectAdminForm();

				endforeach;
			endif;


			if ($additionalTabs = $this->fetch('additionalFormTabs')):

				echo $additionalTabs;
			endif;

			echo '<div class="img-docs-section">';
				echo $this->element('img_doc_tabs');
			echo '</div>';

			if (isset($menuFields) && !empty($menuFields)):
				echo $this->element(
					'form_tab',
					array(
						'title' => __('Menu'),
						'tabContent' => $this->element('Forms/fields', array('fields' => $menuFields)),
					)
				);
			endif;

			if (isset($metaData) && !empty($metaData)):
				echo $this->element(
					'form_tab',
					array(
						'title' => __('Meta Data'),
						'tabContent' => $this->element('MetaData.metaTab')
					)
				);
			endif;
		?>


		<?php echo $this->fetch('aboveFormSubmit'); ?>

		<?php echo $this->Element('EvCore.../Themed/Admin/Elements/Forms/form_submit'); ?>

		<?php echo $this->fetch('belowFormSubmit'); ?>


	<?php echo $this->Form->end(); ?>

</div>
