<?php
App::uses('TextHelper', 'View/Helper');

class TextExtHelper extends TextHelper {

/**
 * Truncates text.
 *
 * Cuts a string to the length of $length and replaces the last characters
 * with the ellipsis if the text is longer than length.
 *
 * ### Options:
 *
 * - `ellipsis` Will be used as Ending and appended to the trimmed string (`ending` is deprecated)
 * - `exact` If false, $text will not be cut mid-word
 * - `html` If true, HTML tags would be handled correctly
 * - `stripTags` If true, HTML will be stripped, to allow some HTML tags use `allowedTags`
 * - `allowedTags` A string of tags allowed when stripping HTML, e.g. '<strong><em>'
 *
 * @param string $text String to truncate.
 * @param int $length Length of returned string, including ellipsis.
 * @param array $options An array of html attributes and options.
 * @return string Trimmed string.
 * @see CakeText::truncate()
 * @link http://book.cakephp.org/2.0/en/core-libraries/helpers/text.html#TextHelper::truncate
 */
	public function truncate($text, $length = 100, $options = []) {
		// To prevent issues with minification of HTML we want to replace any new lines with spaces.
		$text = preg_replace('/\n\s*/', ' ', $text);
		if (! empty($options['allowedTags'])) {
			$text = strip_tags($text, $options['allowedTags']);
		} elseif (! empty($options['stripTags'])) {
			$text = strip_tags($text);
		}

		return parent::truncate($text, $length, $options);
	}

}
