<?php

App::uses('PaginatorHelper', 'View/Helper');

class PaginatorExtHelper extends PaginatorHelper {

/**
 * Echos out the prev and next canonical meta tags
 *
 * @param  string $model The model to base the paginate functionality off of
 * @return void
 */
	public function canonical($model = null) {
		echo $this->_metaLink('Prev', $model);
		echo $this->_metaLink('Next', $model);
	}

/**
 * Retuns the appropriate meta tag for the requested paginator direction, etiher
 * 'Prev' or 'Next'
 *
 * @param  string $which Contains the appropriate paginator direction
 * @param  string $model The model to base the paginate functionality off of
 * @return string The meta tag ready to show on the DOM
 */
	protected function _metaLink($which, $model = null) {
		$check = 'has' . $which;
		$options = array(
			'url' => array(), 'step' => 1, 'escape' => true, 'model' => null
		);

		$paging = $this->params($options['model']);

		foreach (array_keys($options) as $key) {
			${$key} = $options[$key];
			unset($options[$key]);
		}

		if ($this->{$check}($model)) {
			$url = array(
				'page' => $paging['page'] + ($which === 'Prev' ? $step * -1 : $step),
			);

			return $this->Html->meta(
				'link',
				Router::url($url, true),
				array(
					'rel' => strtolower($which),
					'type' => null,
					'title' => null
				)

			);
		}

		return '';
	}

/**
 * Returns the meta-links for a paginated result set. Extended to allow requests
 * for absolute URLs
 *
 * @param array $options Array of options.
 * @return string|null Meta links.
 */
	public function meta($options = []) {
		if (! empty($options['full_base'])) {
			// force absolute URLs
			$this->options['url']['full_base'] = true;
		}

		return parent::meta($options);
	}

}
