<?php

App::uses('View', 'View');

class EvCustomView extends View {

/**
 * When extending a view file (layout/view/element), this variable will be set to true.
 *
 * @var bool
 */
	protected $_findExtension = false;

/**
 * Overridden to pass data when rendering parent files. When debug mode is enabled the view is wrapped in html comments
 * showing the location of the view being rendered.
 *
 * @param string $viewFile Filename of the view
 * @param array $data Data to include in rendered view. If empty the current View::$viewVars will be used.
 * @return string Rendered output
 * @triggers View.beforeRenderFile $this, array($viewFile)
 * @triggers View.afterRenderFile $this, array($viewFile, $content)
 * @throws CakeException when a block is left open.
 */
	protected function _render($viewFile, $data = array()) {
		if (empty($data)) {
			$data = $this->viewVars;
		}

		$this->_current = $viewFile;
		$initialBlocks = count($this->Blocks->unclosed());

		$eventManager = $this->getEventManager();
		$beforeEvent = new CakeEvent('View.beforeRenderFile', $this, array($viewFile));

		$eventManager->dispatch($beforeEvent);
		$content = $this->_evaluate($viewFile, $data);

		$afterEvent = new CakeEvent('View.afterRenderFile', $this, array($viewFile, $content));

		$afterEvent->modParams = 1;
		$eventManager->dispatch($afterEvent);
		$content = $afterEvent->data[1];

		if (isset($this->_parents[$viewFile])) {
			$this->_stack[] = $this->fetch('content');
			$this->assign('content', $content);

			//Pass the data through to the parent so extend elements get the correct element data.
			$content = $this->_render($this->_parents[$viewFile], $data);
			$this->assign('content', array_pop($this->_stack));
		}

		$remainingBlocks = count($this->Blocks->unclosed());

		if ($initialBlocks !== $remainingBlocks) {
			throw new CakeException(__d('cake_dev', 'The "%s" block was left open. Blocks are not allowed to cross files.', $this->Blocks->active()));
		}

		if (Configure::read('EvImg.lazyload') && !in_array(strtolower($this->theme), ['admin', 'ajax'])) {
			$content = $this->lazyLoadImageTags($content);
		}

		if (Configure::read('debug') == '2') {
			$startComment = '<!-- START: ' . $viewFile . ' -->';
			$endComment = '<!-- END: ' . $viewFile . ' -->';

			if (!empty($this->viewVars['isAjaxRequest'])) {
				$startComment = null;
				$endComment = null;
			}
			return $startComment . $content . $endComment;
		}

		return $content;
	}

/**
 * redefined to check and loop our collection of helpers for overriden files
 *
 * Interact with the HelperCollection to load all the helpers.
 *
 * @return void
 */
	public function loadHelpers() {
		// Evoluted Amend. Loop and check for any plugins in helpers
		// Check these haven't been overwritten
		if (! empty($this->helpers)) {

			if (isset($this->helpers['DebugKit.Toolbar'])) {
				$debugKit = $this->helpers['DebugKit.Toolbar'];
				unset($this->helpers['DebugKit.Toolbar']);
			}

			$this->helpers = EvClassRegistry::checkOverridingItems('helpers', $this->helpers);

			if (isset($debugKit)) {
				$this->helpers['DebugKit.Toolbar'] = $debugKit;
			}
		}

		parent::loadHelpers();
	}

/**
 * Loads a helper. Delegates to the `HelperCollection::load()` to load the helper
 *
 * @param string $helperName Name of the helper to load.
 * @param array $settings Settings for the helper
 * @return Helper a constructed helper object.
 * @see HelperCollection::load()
 */
	public function loadHelper($helperName, $settings = array()) {
		// check for a plugin / overriding file
		$origHelper = $helperName;

		if (! empty($settings['className'])) {
			$helperName = $settings['className'];
		}

		$helperName = EvClassRegistry::findOverrideHelper($helperName);
		$settings['className'] = $helperName;

		// as we have set the className, we need to chop up the original
		// helper call if it was a plugin to set the alias correctly.
		$helperName = EvClassRegistry::getNewArrayKey($origHelper);

		return parent::loadHelper($helperName, $settings);
	}

/**
 * Provides view or element extension/inheritance. Views can extends a
 * parent view and populate blocks in the parent template.
 *
 * @param string $name The view or element to 'extend' the current one with.
 * @return void
 * @throws LogicException when you extend a view with itself or make extend loops.
 * @throws LogicException when you extend an element which doesn't exist
 */
	public function extend($name) {
		$this->_findExtension = true;

		parent::extend($name);

		$this->_findExtension = false;
	}

/**
 * Get the filename for a View template
 *
 * @param string $name Controller action to find template filename for
 * @return string|bool Template filename or false if an unexpected exception if thrown
 */
	public function getViewFileName($name = null) {
		try {
			return $this->_getViewFileName($name);
		} catch (Exception $e) {
			return false;
		}
	}

/**
 * Finds an element filename, returns false on failure. Overridden to stop infinite loops when attempting to extend app
 * views from plugin views.
 *
 * @param string $name The name of the element to find.
 * @return mixed Either a string to the element filename or false when one can't be found.
 */
	protected function _getElementFileName($name) {
		list($plugin, $name) = $this->pluginSplit($name);

		$paths = $this->_paths($plugin);

		$exts = $this->_getExtensions();

		foreach ($exts as $ext) {
			foreach ($paths as $path) {
				$elementPath = $path . 'Elements' . DS . $name . $ext;

				//Stop elements extending
				if ($this->_findExtension && $elementPath == $this->_current) {
					continue;
				}

				if (file_exists($elementPath)) {
					return $elementPath;
				}
			}
		}
		return false;
	}

/**
 * Fetch the content for a block. If a block is empty or undefined '' will be returned.
 *
 * @param string $name Name of the block
 * @param string $default Default text
 * @return string default The block content or $default if the block does not exist.
 * @see ViewBlock::get()
 */
	public function fetch($name, $default = '') {
		$fetch = $this->Blocks->get($name, $default);

		return trim($fetch);
	}

/**
 * Replaces `src` on all img tags with a `data-src` attribute to allow for lazy loading
 * of images.
 *
 * @param string $data HTML string
 * @return string
 */
	public function lazyLoadImageTags($data) {
		if (empty($this->Img)) {
			$this->Img = $this->loadHelper('EvImg.Img');
		}

		return $this->Img->lazyLoadImageTags($data);
	}
}
