<?php
	// Alert the user as to when their session is about to expire so they can save any changes.
	$this->Html->script(
		'https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.19.1/moment.min.js',
		[
			'inline' => false,
			'integrity' => "sha256-zG8v+NWiZxmjNi+CvUYnZwKtHzFtdO8cAKUIdB8+U9I=",
			'crossorigin' => "anonymous"
		]
	);

	$this->Html->scriptBlock(
		'
			var eventTime= ' . $this->Session->read('Config.time') . ';
			var currentTime = Math.floor(Date.now() / 1000);
			var diffTime = eventTime - currentTime;
			var duration = moment.duration(diffTime*1000, \'milliseconds\');
			var interval = 1000 * 60; // Every minute

			setInterval(function(){
			  	duration = moment.duration(duration - interval, \'milliseconds\');
			  	if (duration.hours() == 0 && duration.minutes() <= 15) {
			  		$("#logout-warning").slideDown();
			  		$(\'.logout-countdown\').text(duration.minutes());
			  		if (duration.minutes <= 0) {
			  			$("#logout-warning .logout-warning-message").text("You have now been logged out.");
			  		}
			    }
			}, interval);
		',
		[
			'inline' => false,
			'safe' => false
		]
	);
?>

<div id="logout-warning" style="display:none">
	<p class="alert alert-danger">
		<strong>
			<span class="logout-warning-message">
				WARNING: Your login session will expire in <span class="logout-countdown"></span> minutes.
			</span>
		</strong>
	</p>
</div>
