<?php
	//Get the tracking ID
	if (! isset($trackingCode)):
		if (Configure::read('app.environment') === 'PRODUCTION') {
			$trackingCode = Configure::read('SiteSetting.general.google_analytics');
		} elseif (Configure::check('SiteSetting.general.google_analytics_dev')) {
			$trackingCode = Configure::read('SiteSetting.general.google_analytics_dev');
		} else {
			$trackingCode = false;
		}
	endif;

	if (! isset($trackingSite)):
		$trackingSite = $_SERVER['HTTP_HOST'];
	endif;

	if (!$trackingCode) return;
?>
<script>
	(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
	})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

	ga('create', '<?php echo $trackingCode; ?>', '<?php echo $trackingSite; ?>');
	ga('send', 'pageview');

	// Ensure that GA is loaded before listening for events
	ga(function() {

		// Fire GA event after 10 seconds for bounce rate measurement
		setTimeout(function() {
			ga('send', 'event', 'System', '10 Second Stay');
		}, 10000);

		// Track Mailto Links
		var mailtoLinks = document.querySelectorAll('a[href^="mailto:"]');

		for (var i = 0; i < mailtoLinks.length; i++) {
			mailtoLinks[i].addEventListener('click', function(event) {
				var address = this.getAttribute('href');
				var target = this.getAttribute('target');

				var params = {};

				if (typeof target == 'undefined' || target != '_blank') {
					event.preventDefault();

					params.hitCallback = function () {
						document.location = address;
					}
				}

				ga('send', 'event', 'Contact', 'Click Email Address', address, params);

				return true;
			});
		}

		// Track Tel Links
		var telephoneLinks = document.querySelectorAll('a[href^="tel:"]');

		for (var i = 0; i < telephoneLinks.length; i++) {
			telephoneLinks[i].addEventListener('click', function(event) {
				var phoneNumber = this.getAttribute('href');
				var target = this.getAttribute('target');

				var params = {};

				if (typeof target == 'undefined' || target != '_blank') {
					params.hitCallback = function () {
						event.preventDefault();

						document.location = phoneNumber;
					}
				}

				ga('send', 'event', 'Contact', 'Click Phone Number', phoneNumber, params);

				return true;
			});
		}

		// Track PDF Links
		var pdfLinks = document.querySelectorAll('a[href$=".pdf"]');

		for (var i = 0; i < pdfLinks.length; i++) {
			pdfLinks[i].addEventListener('click', function(event) {
				var pdf = this.getAttribute('href');
				var target = this.getAttribute('target');

				var params = {};

				if (typeof target == 'undefined' || target != '_blank') {
					event.preventDefault();

					params.hitCallback = function () {
						document.location = pdf;
					}
				}

				ga('send', 'event', 'Downloads', 'Download PDF', pdf, params);

				return true;
			});
		}

		// Track external links
		var externalLinks = document.querySelectorAll("a[href^='http:'],a[href^='https:']");

		for (var i = 0; i < externalLinks.length; i++) {
			if (externalLinks[i].href.indexOf("<?= $trackingSite; ?>") == -1) {
				externalLinks[i].addEventListener('click', function(event) {
					var address = this.getAttribute('href');
					var target = this.getAttribute('target');

					var params = {};

					if (typeof target == 'undefined' || target != '_blank') {
						event.preventDefault();

						params.hitCallback = function () {
							document.location = address;
						}
					}

					ga('send', 'event', 'External', 'Clicked External Link', address, params);

					return true;
				});
			}
		}

		<?php
			// Fetch additional ga script from extended views.
			echo $this->fetch('gaScriptBlock');
		?>
	});
</script>
