<?php

App::uses('Controller', 'Controller');
App::uses('TextExtHelper', 'EvCore.View/Helper');
App::uses('View', 'View');

class TextExtHelperTest extends CakeTestCase {

	public $Text = null;

	public function setUp() {
		parent::setUp();
		$Controller = new Controller();
		$View = new View($Controller);
		$this->Text = new TextExtHelper($View);
	}

	public function testTruncationWithNewLines() {
		$expected = '<p>Hello</p> <p>Goodbye</p>';
		$result = $this->Text->truncate("<p>Hello</p>\n<p>Goodbye</p>");
		$this->assertEquals($expected, $result);
	}

	public function testTruncationWithStripTagsEnabled() {
		$expected = 'Hello Goodbye';
		$result = $this->Text->truncate("<p>Hello</p>\n<p>Goodbye</p>", 100, ['stripTags' => true]);
		$this->assertEquals($expected, $result);
	}

	public function testTruncationWithAllowedTagsEnabled() {
		$expected = '<strong>Hello</strong> <em>Goodbye</em>';
		$result = $this->Text->truncate("<p><strong>Hello</strong></p>\n<p><em>Goodbye</em></p>", 100, ['allowedTags' => '<strong><em>']);
		$this->assertEquals($expected, $result);
	}

}
