<?php

App::uses('AppModel', 'Model');

class UserGroup extends AppModel {

	public $order = array('name' => 'ASC');

	public $actsAs = array(
		'Acl' => array(
			'type' => 'requester',
		),
	);

	public $hasMany = array(
		'User'
	);

	const ADMIN_LEVEL = 20, // lowest level needed to access admin area
		SUPER_ADMIN_LEVEL = 10; // level for super admins (usually evoluted)

	public function afterSave($created, $options = array()) {
		$result = parent::afterSave($created, $options);

		if (empty($this->data['UserGroup']['id'])) {
			return $result;
		}

		if (!empty($this->data['UserGroup']['Permission'])) {
			$aro = EvClassRegistry::init('Aro')->find(
				'first',
				[
					'conditions' => [
						'Aro.model' => $this->alias,
						'Aro.foreign_key' => $this->data['UserGroup']['id']
					]
				]
			);

			if (!empty($aro['Aco'])) {
				$permissionIds = Hash::extract($aro['Aco'], '{n}.Permission.id');
				if (!empty($permissionIds)) {
					EvClassRegistry::init('Permission')->deleteAll(
						[
							'Permission.id' => $permissionIds
						]
					);
				}
			}

			if (!empty($aro['Aro']['id'])) {
				$savePermissions = [];

				$allowPermissions = Hash::extract($this->data['UserGroup']['Permission'], '{s}.allow');
				$allowPermissionData = [
					'aro_id' => $aro['Aro']['id'],
					'_create' => 1,
					'_read' => 1,
					'_update' => 1,
					'_delete' => 1
				];
				foreach ($allowPermissions as $permission) {
					$savePermissions[] = Hash::merge($allowPermissionData, ['aco_id' => $permission]);
				}

				$denyPermissions = Hash::extract($this->data['UserGroup']['Permission'], '{s}.deny');
				$denyPermissionData = [
					'aro_id' => $aro['Aro']['id'],
					'_create' => -1,
					'_read' => -1,
					'_update' => -1,
					'_delete' => -1
				];
				foreach ($denyPermissions as $permission) {
					$savePermissions[] = Hash::merge($denyPermissionData, ['aco_id' => $permission]);
				}

				$result = EvClassRegistry::init('Permission')->saveMany($savePermissions);
			}
		}

		return $result;
	}

	public function parentNode() {
		return null;
	}
}
