<?php

App::uses('CopyableBehavior', 'EvCore.Model/Behavior');

class CustomCopyableBehavior extends CopyableBehavior {

/**
 * Copy a record. Associations can be copied with a recurseLevel > 0.
 *
 * @param obj $Model        Model object.
 * @param int $id           Integer model ID.
 * @param int $recurseLevel The amount of levels to include hasMany and hasOne records.
 * @return bool|array False if the copy failed. The new record if copy successful.
 * @access public
 */
	public function copy($Model, $id, $recurseLevel = 1) {
		$Model->Behaviors->unload('Routable.Routable');
		$Model->Behaviors->unload('EvNavigation.Navigatable');

		return parent::copy($Model, $id, $recurseLevel);
	}

/**
 * Loops through any HABTM results in $this->record and plucks out the join table info, stripping out the join
 * table primary key and the primary key of $Model. This is done instead of a simple collection of IDs of the
 * associated records, since HABTM join tables may contain extra information (sorting order, etc).
 *
 * @param obj   $Model  Model object.
 * @param array $record The record that is being copied.
 * @access private
 * @return array Modified $record.
 */
	private function __convertHabtm($Model, $record) {
		if (!$this->settings[$Model->alias]['habtm']) {
			return $record;
		}

		foreach ($Model->hasAndBelongsToMany as $key => $val) {

			// check whether a custom relationship is used, if so then
			// overwrite the $val['className']
			if ($key != $val['className']) {
				$val['className'] = $key;
			}

			if (!isset($record[$val['className']]) || empty($record[$val['className']])) {
				continue;
			}

			$joinInfo = Hash::extract($record[$val['className']], '{n}.' . $val['with']);

			if (empty($joinInfo)) {
				continue;
			}

			foreach ($joinInfo as $joinKey => $joinVal) {
				$joinInfo[$joinKey] = $this->__stripFields($Model, $joinVal);

				if (array_key_exists($val['foreignKey'], $joinVal)) {
					unset($joinInfo[$joinKey][$val['foreignKey']]);
				}
			}

			$record[$val['className']] = $joinInfo;
		}

		return $record;
	}
}
