<?php

App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');

class EvUserUserRequiresActivationListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.User.manualActivate' => 'notifyAdmin',
		);
	}

	public function notifyAdmin(CakeEvent $event) {
		// send the email
		$Email = new CustomEmail();

		$Email->template('EvCore.manual_activation_required');
		$Email->to(Configure::read('SiteSetting.general.admin_email'));
		$Email->from(array(Configure::read('SiteSetting.general.admin_email') => Configure::read('SiteSetting.general.site_title')));
		$Email->subject(Configure::read('SiteSetting.general.site_title') . ' New User requires Activation');
		$Email->viewVars(array(
			'user' => $event->data['User'],
			'url' => $event->data['url']
		));
		$Email->helpers(array(
				'Html'
		));
		$Email->send();

		return;
	}
}
