<?php

App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');

class EvUserEmailVerificationListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.User.emailActivate' => 'sendVerificationEmail',
		);
	}

	public function sendVerificationEmail(CakeEvent $event) {
		// send the email
		$Email = new CustomEmail();

		$Email->template('EvCore.email_verification');
		$Email->to($event->data['User'][$event->data['Model']]['email']);
		$Email->from(array(Configure::read('SiteSetting.general.admin_email') => Configure::read('SiteSetting.general.site_title')));
		$Email->subject(Configure::read('SiteSetting.general.site_title') . ' Verify your account');
		$Email->viewVars(array(
			'user' => $event->data['User'],
			'url' => $event->data['url']
		));
		$Email->helpers(array(
				'Html'
		));
		$Email->send();

		return;
	}
}
