<?php

App::uses('CakeEventListener', 'Event');

class CreatedActiveAdminUserListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCore.Model.User.createdActiveAdminUser' => 'sendNewAdminPasswordResetEmail',
		);
	}

	public function sendNewAdminPasswordResetEmail(CakeEvent $event) {
		if (empty($event->data['userId'])) {
			return;
		}

		if (!empty(Configure::read('EvCore.new_admin_users_password_reset'))) {
			$User = EvClassRegistry::init('EvCore.User');

			$user = $User->findById($event->data['userId']);

			if (!empty($user)) {
				$code = md5(uniqid());

				$User->id = $event->data['userId'];
				$passwordReset = $User->save([
					'password_reset_code' => $code,
					'password_reset_code_expires' => gmdate('Y-m-d H:i:s', strtotime('+1 hour'))
				]);

				$url = Router::url(
					[
						'admin' => true,
						'plugin' => 'ev_core',
						'controller' => 'users',
						'action' => 'admin_password_reset_callback',
						$code
					],
					true
				);

				$Email = new CustomEmail();

				$Email->template('EvCore.new_admin_password_email');
				$Email->to($user['User']['email']);
				$Email->from(array(Configure::read('SiteSetting.general.admin_email') => Configure::read('SiteSetting.general.site_title')));
				$Email->subject(Configure::read('SiteSetting.general.site_title') . ' Create Password');
				$Email->viewVars(array(
					'user' => $user,
					'code' => $code,
					'url' => $url
				));
				$Email->helpers(array(
						'Html'
				));
				$Email->send();
			}
		}

		return;
	}
}
