<?php
/**
 * Static content controller.
 *
 * This file will render views from views/pages/
 *
 * PHP 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Controller
 * @since         CakePHP(tm) v 0.2.9
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

App::uses('AppController', 'Controller');
App::uses('ArrayUtil', 'EvCore.Lib');
App::uses('Folder', 'Utility');

/**
 * Static content controller
 *
 * Override this controller by placing a copy in controllers directory of an application
 *
 * @package       app.Controller
 * @link http://book.cakephp.org/2.0/en/controllers/pages-controller.html
 */
class PagesController extends AppController {

/**
 * Controller name
 *
 * @var string
 */
	public $name = 'Pages';

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'home',
			'view'
		));
	}

/**
 * Add/Edit a page
 *
 * @param int $id ID of page to edit
 * @return void
 */
	public function admin_edit($id = null) {
		$Model = $this->{$this->modelClass};
		parent::admin_edit($id);
		// If a redirect_url has been previously set we want to hide the route fields as there is no
		// need for these as no route is going to be saved for this content.
		if (!empty($this->request->data[$Model->alias]['redirect_url'])) {
			unset($this->viewVars['fields']['Route.id']);
			unset($this->viewVars['fields']['Route.alias']);
		}
		return;
	}

	protected function _adminIndexColumnsWhitelist() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;
		$whitelist = parent::_adminIndexColumnsWhitelist();
		$whitelist[] = $modelAlias . '.internal_title';
		return $whitelist;
	}

	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};
		$fields = parent::_adminFormFields();
		// Only enable the internal_title field for Super Users as this field is intended for pages
		// used by the system (e.g. when using `assignPage()`). This field provides a way of giving
		// context to the data's use (e.g. for a homepage, contact page, checkout confirmation).
		if (!$this->Permissions->hasSuperAdminPermission($this->Auth->user())) {
			$fields[$Model->alias . '.internal_title']['disabled'] = true;
		}
		// Only display the redirect_url field to Super Users. This should be used for setting a
		// redirect on pages that aren't intended for being directly accessed by a page route, but
		// are used for another page's content (e.g. a contact page using `assignPage()`).
		if (!$this->Permissions->hasSuperAdminPermission($this->Auth->user())) {
			unset($fields[$Model->alias . '.redirect_url']);
			unset($fields[$Model->alias . '.is_protected']);
		} else {
			if (! empty($fields[$Model->alias . '.redirect_url'])) {
				$additionalFields[$Model->alias . '.redirect_url'] = $fields[$Model->alias . '.redirect_url'];
			} else {
				$additionalFields[$Model->alias . '.redirect_url'] = [
					'label' => __d('ev_core', 'Redirect URL'),
					'type' => 'string'
				];
			}

			$addAfterKey = ! empty($fields['Route.alias']) ? 'Route.alias' : $Model->alias . '.title';

			$fields = ArrayUtil::addAfter($fields, $addAfterKey, $additionalFields);
		}
		return $fields;
	}

/**
 * Returns the view template and associated data
 *
 * @param int $id The unique id of the item we're returning
 * @return void
 */
	public function view($id) {
		$Model = $this->{$this->modelClass};

		$data = $Model->readForView($id);

		if (empty($data['Page'])) {
			throw new NotFoundException();
		} elseif (!empty($data['Page']['redirect_url'])) {
			// This page cannot be accessed directly, redirect to the provided redirect URL. This
			// is intended for page content that is assigned to other pages on the site and not
			// intended to be viewed as a page itself.
			return $this->redirect($data['Page']['redirect_url']);
		}

		$this->set('data', $data);
		$this->Meta->set($data);

		if ($Model->hasBehavior('EvTemplates.Template')) {
			$originalView = $this->view;

			$this->view = $this->Tpl->getTemplate($data);

			// if no view template is returned from getTemplate then re-assign our original view template
			if (! $this->view) {
				$this->view = $originalView;
			}
		}
	}

/**
 * Displays a view
 *
 * @param mixed What page to display
 * @return void
 */
	public function display() {
		$path = func_get_args();

		$count = count($path);
		if (!$count) {
			$this->redirect('/');
		}
		$page = $subpage = $title_for_layout = null;

		if (!empty($path[0])) {
			$page = $path[0];
		}
		if (!empty($path[1])) {
			$subpage = $path[1];
		}
		if (!empty($path[$count - 1])) {
			$title_for_layout = Inflector::humanize($path[$count - 1]);
		}
		$this->set(compact('page', 'subpage', 'title_for_layout'));
		$this->render(implode('/', $path));
	}
}
