<?php
App::uses('AppComponent', 'Controller/Component');

class MailQueueComponent extends AppComponent {

/**
 * send an email via the queue system
 *
 * This method has its own default parameters for things like the from address and the helpers, however
 * the params you provide will be merged in and take priority over the defaults. For full usage details
 * please read the core-docs, however a basic example of the params you can pass would be as follows:
 *
 *	$params = [
 *		'from' => [
 *			'user@example.com' => 'Site Name'
 *		],
 *		'to' => [
 *			'jsmith@example.com' => 'John Smith'
 *		],
 *		'subject' => 'New Account Details',
 *		'viewVars' => [
 *			'name' => 'John Smith',
 *			'websiteurl' => 'http://oursite.com'
 *		],
 *		'helpers' => [
 *			'Html',
 *			'Number',
 *			'Text'
 *		],
 *		'template' => 'EvCheckout.Orders/adminNewOrder'
 *	];
 *
 * @param  array $params Array of email params
 * @return bool Status of the job
 */
	public function send($params) {
		$defaultParams = [
			'from' => [
				Configure::read('SiteSetting.general.admin_email') => Configure::read('SiteSetting.general.site_title')
			],
			'helpers' => [
				'Html',
				'Number',
				'Text'
			]
		];

		$params = array_merge($defaultParams, $params);

		$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');

		if ($QueuedTask->createJob('CustomEmail', $params)) {
			return true;
		}

		return false;
	}
}
