<?php
class AddAliasIndexOnAco extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_alias_index_on_aco';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'acos' => array(
					'indexes' => array(
						'alias' => array('column' => 'alias', 'unique' => 0, 'length' => array('alias' => '191')),
					),
				),
				'aros' => array(
					'indexes' => array(
						'model_foreign_key' => array('column' => array('model', 'foreign_key'), 'unique' => 0, 'length' => array('model' => '191')),
					),
				)
			),
		),
		'down' => array(
			'drop_field' => array(
				'acos' => array(
					'indexes' => array('alias')
				),
				'aros' => array(
					'indexes' => array('model_foreign_key')
				)
			)
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			// Pull in all the controller actions to be used as aco records.
			// Only do this if the Acos table is empty as it may have been run in a previous migration.
			$Acos = EvClassRegistry::init('Acos');
			$existing = $Acos->find('first');

			if (empty($existing)) {
				$PermissionsShell = new PermissionsShell();
				$PermissionsShell->params = [
					'update-default-permissions' => true,
				];
				$PermissionsShell->startup();
				$PermissionsShell->sync();
			}
		}

		return true;
	}
}
