<?php

App::uses('AclShell', 'Console/Command');
App::uses('PermissionsShell', 'EvCore.Console/Command');

class AddingAclTables extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'adding_acl_tables';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'acos' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'key' => 'primary'),
					'parent_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10),
					'model' => array('type' => 'string', 'null' => true),
					'foreign_key' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10),
					'alias' => array('type' => 'string', 'null' => true),
					'lft' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10),
					'rght' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_unicode_ci', 'engine' => 'InnoDB'),
				),
				'aros' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'key' => 'primary'),
					'parent_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10),
					'model' => array('type' => 'string', 'null' => true),
					'foreign_key' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10),
					'alias' => array('type' => 'string', 'null' => true),
					'lft' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10),
					'rght' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_unicode_ci', 'engine' => 'InnoDB'),
				),
				'aros_acos' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'key' => 'primary'),
					'aro_id' => array('type' => 'integer', 'null' => false, 'length' => 10, 'key' => 'index'),
					'aco_id' => array('type' => 'integer', 'null' => false, 'length' => 10),
					'_create' => array('type' => 'string', 'null' => false, 'default' => '0', 'length' => 2),
					'_read' => array('type' => 'string', 'null' => false, 'default' => '0', 'length' => 2),
					'_update' => array('type' => 'string', 'null' => false, 'default' => '0', 'length' => 2),
					'_delete' => array('type' => 'string', 'null' => false, 'default' => '0', 'length' => 2),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'ARO_ACO_KEY' => array('column' => array('aro_id', 'aco_id'), 'unique' => 1)
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_unicode_ci', 'engine' => 'InnoDB'),
				)
			),
		),
		'down' => array(
			'drop_table' => array(
				'acos',
				'aros',
				'aros_acos'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			//Save default user groups as aro records.
			$aroData = [
				[
					'parent_id' => null,
					'model' => 'UserGroup',
					'foreign_key' => 1
				],
				[
					'parent_id' => null,
					'model' => 'UserGroup',
					'foreign_key' => 2
				],
				[
					'parent_id' => null,
					'model' => 'UserGroup',
					'foreign_key' => 3
				],
			];

			EvClassRegistry::init('Aro')->saveMany($aroData);
		}

		return true;
	}
}
