<?php
class AddedUuidFieldToTheDocumentsTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'added_uuid_field_to_the_documents_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'documents' => array(
					'uuid' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 36, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4', 'after' => 'id'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'documents' => array('uuid'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
	    return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			// update the current document recods
			ClassRegistry::init('Document')->query("UPDATE documents SET uuid = uuid() WHERE uuid IS NULL");
		}
		return true;
	}
}
