<?php
App::uses('MigrationUtil', 'EvMigrationUtil.Lib');
class AddGoogleAnalyticsDevelopmentField extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_google_analytics_development_field';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$SiteSettingUtil = MigrationUtil::init('EvSiteSettings.SiteSetting');

		if ($direction == 'up') {
			$SiteSettingUtil->createOnceWithCategory('google_analytics_dev', 'general', 'string', [
				'name' => 'Google Analytics Development Tracking Code',
				'valueOptions' => '',
				'value' => null,
				'sequence' => 40,
				'preventEdit' => false,
				'categoryName' => 'General',
				'categorySequence' => 10,
			]);
		} else {

			$SiteSettingUtil->deleteWithSlug('google_analytics_dev', 'general');
		}
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
