(function(ev, $, undefined) {
	'use strict';
	ev.cloneable = {};

	var plugin;
	var settings = {
		container: '[data-cloneable-container]',
		row: '[data-cloneable-row]',
		addButton: '[data-cloneable-add]',
		removeButton: '[data-cloneable-remove]',
		idField: '[data-cloneable-id-field]',
		removedIdList: '[data-cloneable-removed-ids]'
	};

	ev.cloneable.init = function() {
		plugin = this;

		if ($(settings.container)) {
			$(settings.container).each(function() {

				var container = $(this);

				plugin.bindAdd(container);

				$(settings.row, container).each( function() {
					plugin.bindRowControls($(this));
				});

			});
		}
	}

	ev.cloneable.bindAdd = function(container) {
		var addButton = $(settings.addButton, container);
		addButton.on('click', function() {
			plugin.addRow(container);
		})
	}

	ev.cloneable.addRow = function(container) {
		var cloneRow = $(settings.row, container).last();

		if (cloneRow.hasClass('hidden')) {
			// If all attributes have been removed and the last one was hidden
			cloneRow.removeClass('hidden');
		} else {
			// Otherwise add a new one
			var newClone = cloneRow.clone();
			plugin.clearValues(newClone, true);
			this.bindRowControls(newClone);
			cloneRow.after(newClone);
		}
	}

	ev.cloneable.removeRow = function(row) {

		var container = row.closest(settings.container);

		// Add the removed id to the list if it is not a new field
		var id = $(settings.idField, row).val();
		if (id) {
			var idList = $(settings.removedIdList, container);
			idList.val( idList.val() + ',' + id );
		}

		if ($(settings.row, container).length <= 1) {
			// Don't delete the last one, just hide it.
			row.addClass('hidden');
			plugin.clearValues(row, false);
		} else {
			row.remove();
		}
	}

	ev.cloneable.bindRowControls = function(row) {
		$(settings.removeButton, row).on('click', function() {
			plugin.removeRow(row);
		});
	}

	ev.cloneable.clearValues = function(row, refreshId) {
		row.find("input, select, textarea").each( function() {
			// Clear any old values
			if (this.type == "checkbox" || this.type == "radio") {
				this.checked = false;
			} else {
				this.value = "";
			}

			// Set up the new key by adding one to the last element's key
			// so data[Model][key][field] becomes data[Model][key+1][field]
			if (refreshId) {
				this.name = this.name.replace(/\[([0-9]+)\]/, function(match, key) {
					return '[' + (parseInt(key) + 1) + ']';
				});
			}
		});
	}

}(window.ev = window.ev || {}, jQuery));

ev.cloneable.init();
