<h1>Register</h1>

<?php

echo $this->Form->create('User', array('url' => array('action' => 'register')));

    echo $this->Form->addField('User.first_name', array(
        'type' => 'string',
        'class' => 'required'
    ));
    echo $this->Form->addField('User.last_name', array(
        'type' => 'string',
        'class' => 'required'
    ));

    echo $this->Form->addField('User.email', array(
        'type' => 'email',
        'class' => 'required email not-value'
    ));

    echo $this->Form->addField('User.password', array(
        'type' => 'password',
        'autocomplete' => 'off',
        'class' => 'required'
    ));

    if (Configure::check('SiteSetting.users.password_rules')):
    	echo Configure::read('SiteSetting.users.password_rules');
   	endif;

    echo $this->Form->addField('User.confirm_password', array(
        'type' => 'password',
        'autocomplete' => 'off',
        'class' => 'required'
    ));

    echo $this->Form->addField('User.phone', array(
        'type' => 'string',
        'class' => 'required'
    ));

    if (isset($showReCaptcha) && $showReCaptcha === true):
	    echo $this->Form->recaptcha('User.g-recaptcha-response', [
			'data-sitekey' => Configure::read('EvCore.userReCaptcha.siteKey')
		]);
	endif;

    echo $this->Form->submit('Register');

echo $this->Form->end();
