<?php

App::uses('Controller', 'Controller');
App::uses('NumberExtHelper', 'EvCore.View/Helper');
App::uses('View', 'View');

class NumberExtHelperTest extends CakeTestCase {

	public $Number = null;

	public function setUp() {
		parent::setUp();
		$Controller = new Controller();
		$View = new View($Controller);
		$this->Number = new NumberExtHelper($View);
	}

	public function testWholeCurrency() {
		$expected = '£45';
		$result = $this->Number->wholeCurrency(45.12, 'GBP');
		$this->assertEquals($expected, $result);
	}

	public function testWholeCurrencyRoundUp() {
		$expected = '£67';
		$result = $this->Number->wholeCurrency(66.52, 'GBP');
		$this->assertEquals($expected, $result);
	}

}
