<?php

App::uses('AppComponent', 'Controller/Component');
App::uses('BasicPermissions', 'EvCore.Lib');

class PermissionsComponent extends AppComponent {

	public function __construct(ComponentCollection $collection, $settings = array()) {
		parent::__construct($collection, $settings);

		$this->Permissions = new BasicPermissions(
			EvClassRegistry::init('EvCore.UserGroup')
		);
	}

	/**
	 * magic method to check if the function exists in the lib file and call it if so
	 * if not, it will try and return the string we were trying to Inflect
	 * if it can't do that, it will just return false
	 *
	 */
	public function __call($name, $arguments) {
		if (method_exists($this->Permissions, $name)) {

			return call_user_func_array(array($this->Permissions, $name), $arguments);
		}

		// we can't find it, return false
		return false;
	}

	public function injectAdminForm($data, $Model, $id) {
		if (Configure::read('EvCore.enable_user_group_permissions') == true) {
			$acos = EvClassRegistry::init('Aco')->find('threaded');
			$this->_controller->set('permissions', $acos);
		}

		return null;
	}
}
