<?php

App::uses('AuthComponent', 'Controller/Component');
App::uses('CakeEventManager', 'Event');

class AuthExtComponent extends AuthComponent {

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @param Controller $controller The controller that called this component.
 * @return void.
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);

		$this->_controller = $controller;
	}

/**
 * Log a user in. Adds beforeLogin and afterLogin callbacks.
 *
 * @param array $user Either an array of user data, or null to identify a user using the current request.
 * @return bool True on login success, false on failure
 * @link http://book.cakephp.org/2.0/en/core-libraries/components/authentication.html#identifying-users-and-logging-them-in
 */
	public function login($user = null) {
		// Fire beforeLogin callback.
		$Event = new CakeEvent(
			'Auth.beforeLogin',
			$this,
			[
				'user' => $user,
			]
		);
		CakeEventManager::instance()->dispatch($Event);

		// Attempt to log user in.
		$response = parent::login($user);

		// Fire afterLogin callback.
		$Event = new CakeEvent(
			'Auth.afterLogin',
			$this,
			[
				'user' => $user,
				'authorised' => $response,
			]
		);
		CakeEventManager::instance()->dispatch($Event);

		return $response;
	}

/**
 * Log a user out. Adds beforeLogout and afterLogout callbacks.
 *
 * @return string AuthComponent::$logoutRedirect
 * @link http://book.cakephp.org/2.0/en/core-libraries/components/authentication.html#logging-users-out
 */
	public function logout() {
		// Fire beforeLogout callback.
		$Event = new CakeEvent(
			'Auth.beforeLogout',
			$this
		);
		CakeEventManager::instance()->dispatch($Event);

		// Log out user.
		$redirect = parent::logout();

		// Fire afterLogout callback.
		$Event = new CakeEvent(
			'Auth.afterLogout',
			$this,
			[
				'redirect' => $redirect,
			]
		);
		CakeEventManager::instance()->dispatch($Event);

		return $redirect;
	}

}
