<?php

$config = array(
	'EvCore' => array(
		'route' => array(
			'Page' => array(
				'controller' => 'ev_core.pages',
				'action' => 'view',
				'plugin' => 'EvCore'
			),
			'User' => array(
				'controller' => 'ev_core.users',
				'action' => 'login',
				'plugin' => 'EvCore'
			)
		),

		'remember_last_admin_filter' => false,
		'remember_last_admin_results_per_page' => false,
		'remember_last_admin_page_number' => false,
		'remember_last_admin_sort_field' => false,

		'allowed_user_group_registration_ids' => array(3),
		'default_user_group_registration_id' => 3,

		// When enabled, this will forcefully redirect any direct controller urls
		// to a valid route alias should one exist. This should genrally be kept
		// on across all websites, however may interfier with specialist setups.
		'force_route_alias_redirects' => true,

		// define project specific Google reCAPTCHA details below. reCAPTCHA elements
		// will automatically show on login and registration forms when login or
		// registration interactions fail by the number of allowed attempts defined
		'userReCaptcha' => false,

		'flashMessages' => array(
			'User' => array(
				'register' => array(
					'autoActivation' => 'Your account has been created, logging in...',
					'emailActivation' => 'Your account has been created, however you will be unable to login until you have clicked the link in the verification email you have been sent.',
					'manualActivation' => 'Your account has been created but needs manually verifying by an administrator. You will be emailed once your account is active.',
				)
			),
		),

		'enable_user_group_permissions' => false,

		'new_admin_users_password_reset' => false, //Send an email out to admin users when there account has been created. Only sends on creation and if the user is active.

		'validatePassword' => array(
			1 => '_validatePasswordAdminUser',
			2 => '_validatePasswordAdminUser',
			3 => '_validatePasswordFrontendUser',
		),

		// Set an AWS bucket and the relevant credentials to upload documents and images to Amazon's
		// S3 service rather than storing locally.
		's3Upload' => array(
			'bucket' => null,
			'key_prefix' => 'assets',
			'region' => 'eu-west-1',
			'credentials' => array(
				'key' => null,
				'secret' => null
			)
		)
	)
);
