<?php
class AddedPasswordDictionaryTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'added_password_dictionary_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'password_dictionary' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'password' => array('type' => 'string', 'null' => false, 'length' => 254, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4'),
					'created' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_unicode_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'password_dictionary'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			// populates the db table from txt based file
			$filepath = dirname(__FILE__) . DS . '..' . DS . 'Schema' . DS . 'password_dictionary.txt';
			ClassRegistry::init('EvCore.PasswordDictionary')->initalPopulate($filepath);
		}
		return true;
	}
}
