<?php

App::uses('PluginInstallShell', 'shells');

class EvCoreInstallShell extends PluginInstallShell
{
	public $uses = array(
		'EvCore.User',
		'EvCore.UserGroup',
		'EvCore.Page'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run()
	{
		parent::run();

		$this->UserGroup->saveMany(
			array(
				array(
					'name' => 'Administrator',
					'level' => 10,
					'is_active' => 1
				),
				array(
					'name' => 'Super User',
					'level' => 20,
					'is_active' => 1
				),
				array(
					'name' => 'User',
					'level' => 30,
					'is_active' => 1
				)
			)
		);

		$this->User->save(
			array(
				'user_group_id' => 1,
				'email' => 'admin@evoluted.net',
				'password' => 'admin',
				'is_active' => 1
			)
		);

		$this->Page->saveMany(
			array(
				array(
					'title' => 'Home Page',
					'body' => '<p>This is the home page.</p>',
					'is_active' => 1,
					'is_protected' => 1
				),
				array(
					'title' => 'Page Not Found',
					'body' => '<p>Sorry, the page you were looking for could not be found.</p>',
					'is_active' => 1,
					'is_protected' => 1
				),
				array(
					'title' => 'Sample',
					// We need to use double quotes around the body value here as it contains new lines.
					'body' => "<p class=\"large\"><strong>Large text:</strong> Proin ornare turpis at nisi <a href=\"../../../\">link to internal page</a> suscipit vestibulum. Integer adipiscing lacus nibh.</p><p class=\"small\"><strong>Small text:</strong>&nbsp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi at fringilla dui, faucibus scelerisque arcu.</p>\r\n<h1>Heading 2 Aliquam lacinia, dolor vestibulum pretium lobortis, ante nisi faucibus elit, ut</h1>\r\n<p>Aliquam et ligula non neque porttitor hendrerit. Nunc ullamcorper imperdiet elementum. <a href=\"http://www.bbc.co.uk\">External link to site</a> orbi in orci arcu, eu adipiscing orci.</p>\r\n<ul>\r\n<li>Pellentesque rhoncus posuere lacus quis volutpat.</li>\r\n<li>Sed iaculis, dui ac fringilla aliquam, ipsum lacus luctus augue, sit amet condimentum augue lectus vel lacus.</li>\r\n<li>Curabitur varius egestas nunc in lobortis.</li>\r\n<li>Phasellus in leo lorem, vel placerat diam.</li>\r\n</ul>\r\n<p>Suspendisse potenti. Aliquam lacinia, dolor vestibulum pretium lobortis, ante nisi faucibus elit, ut ullamcorper magna neque nec mauris.&nbsp;</p>\r\n<ol>\r\n<li>Pellentesque luctus nisi a purus sollicitudin non viverra odio blandit.</li>\r\n<li>Integer sed felis magna.</li>\r\n<li>Phasellus in interdum magna.</li>\r\n<li>Integer sed elit a diam cursus tempus.</li>\r\n</ol>\r\n<h3>Heading 3 phasellus dapibus adipiscing urna, quis ullamcorper neque malesuada id integer at dapibus est</h3>\r\n<p>Integer at dapibus<sup>2</sup> est. Mauris tempus mattis <strong>justo </strong>non condimentum. Pellentesque ullamcorper nulla in<sub>script</sub> tellus <em>sodales ornare</em>. Vivamus iaculis underline.</p>\r\n<table>\r\n<tbody>\r\n<tr><th>&nbsp;</th><th>Header 2</th><th>Header 3</th><th>Header long long long 4</th></tr>\r\n</tbody>\r\n<tbody>\r\n<tr>\r\n<td>Row 1</td>\r\n<td>595959</td>\r\n<td>text text</td>\r\n<td>595956</td>\r\n</tr>\r\n<tr>\r\n<td>Row long long long 2</td>\r\n<td>456477</td>\r\n<td>Morbi a nisl non ante vehicula ultricies vitae id sapien. Curabitur aliquet vestibulum tortor, sed vestibulum nunc pharetra vel.</td>\r\n<td>568687</td>\r\n</tr>\r\n<tr>\r\n<td>Row 3</td>\r\n<td>483929</td>\r\n<td>qwerty asdfg mnbbc</td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td>Row 4</td>\r\n<td>707079</td>\r\n<td>&nbsp;</td>\r\n<td>9090909090</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>Aliquam pharetra felis in sapien lacinia sit amet fermentum elit laoreet. Aenean nec tempor odio. Aenean non ipsum massa.</p>\r\n<p>Heading 4 cras pharetra augue nec augue pellentesque commodo at elementum mauris</p>\r\n<p>Nulla facilisi. Nunc risus ante, vehicula at luctus quis, cursus eget sapien. Proin vel sem mauris. Ut sed lectus leo, vitae sagittis lacus. In nec mattis leo.</p>\r\n<p style=\"padding-left: 30px;\"><strong>Indented</strong>. Nullam quis gravida lorem. Morbi rutrum mauris mi, non tempor nulla. Phasellus molestie metus a sapien tempor a aliquet felis adipiscing. Duis nec est odio.</p>\r\n<p>Proin feugiat dolor id dolor rutrum lobortis elementum risus viverra. Cras pharetra augue nec augue pellentesque commodo at elementum mauris.</p>\r\n<blockquote>\r\n<p><strong>BLOCKQUOTE </strong>Aliquam dolor enim, rutrum ut commodo vitae, ultrices non purus. Donec eu mauris nisl, id egestas lacus. Donec sagittis ullamcorper commodo.</p>\r\n</blockquote>\r\n<p style=\"text-align: left;\"><strong>Left aligned text</strong>. Curabitur eleifend lacus rhoncus justo eleifend a feugiat erat luctus. Proin neque dolor, feugiat sed pretium non, dictum nec mauris.</p>\r\n<p style=\"text-align: center;\"><strong>Centre aligned text</strong>. Nunc est sapien, venenatis et elementum in, posuere non nulla. Curabitur consectetur lacus quis tellus molestie vel placerat tortor semper. Nunc tempor felis sed tortor vulputate volutpat.</p>\r\n<p style=\"text-align: right;\"><strong>Right aligned text</strong>. Donec venenatis, urna a luctus tempor, lorem libero pulvinar nibh, eu rhoncus ipsum mi et leo. Morbi ut erat vitae risus pretium aliquet quis suscipit lectus. Phasellus pretium auctor consequat.</p>",
					'is_active' => 1,
					'is_protected' => 0
				)
			),
			array(
				'callbacks' => false
			)
		);
	}
}
