<?php

App::uses('View', 'View');

class EvCustomView extends View {

	public function __construct(Controller $controller = null) {
		parent::__construct($controller);

		if (!CakePlugin::loaded('EvCurrency')) {
			// Add the GBP format if EvCurrency is not loaded
			$this->_configureCurrency();
		}
	}

	protected function _configureCurrency() {
		$this->Number->addFormat(
			'GBP',
			array(
				'wholeSymbol' => '£', 'wholePosition' => 'before', 'fractionSymbol' => 'p', 'fractionPosition' => 'after',
				'zero' => 0, 'places' => 2, 'thousands' => ',', 'decimals' => '.', 'negative' => '-', 'escape' => true,
				'fractionExponent' => 2
			)
		);
	}

	/**
	 * Overridden render method to add template comments into layout.
	 *
	 * @param string $viewFile Filename of the view
	 * @param array $data Data to include in rendered view. If empty the current View::$viewVars will be used.
	 * @return string Rendered output
	 * @triggers View.beforeRenderFile $this, array($viewFile)
	 * @triggers View.afterRenderFile $this, array($viewFile, $content)
	 * @throws CakeException when a block is left open.
	 */
	protected function _render($viewFile, $data = array()) {
		if (Configure::read('debug') == '2') {
			$startComment = '<!-- START: ' . $viewFile . ' -->';
			$endComment = '<!-- END: ' . $viewFile . ' -->';

			if (!empty($this->viewVars['isAjaxRequest'])) {
				$startComment = null;
				$endComment = null;
			}
			return $startComment . parent::_render($viewFile, $data) . $endComment;
		}

		return parent::_render($viewFile, $data);
	}

	/**
	 * redefined to check and loop our collection of helpers for overriden files
	 *
	 * Interact with the HelperCollection to load all the helpers.
	 *
	 * @return void
	 */
	public function loadHelpers() {
		// Evoluted Amend. Loop and check for any plugins in helpers
		// Check these haven't been overwritten
		if (! empty($this->helpers)) {

			if (isset($this->helpers['DebugKit.Toolbar'])) {
				$debugKit = $this->helpers['DebugKit.Toolbar'];
				unset($this->helpers['DebugKit.Toolbar']);
			}

			$this->helpers = EvClassRegistry::checkOverridingItems('helpers', $this->helpers);

			if (isset($debugKit)) {
				$this->helpers['DebugKit.Toolbar'] = $debugKit;
			}
		}

		parent::loadHelpers();
	}

	/**
	 * Loads a helper. Delegates to the `HelperCollection::load()` to load the helper
	 *
	 * @param string $helperName Name of the helper to load.
	 * @param array $settings Settings for the helper
	 * @return Helper a constructed helper object.
	 * @see HelperCollection::load()
	 */
	public function loadHelper($helperName, $settings = array()) {
		// check for a plugin / overriding file
		$origHelper = $helperName;

		if (! empty($settings['className'])) {
			$helperName = $settings['className'];
		}

		$helperName = EvClassRegistry::findOverrideHelper($helperName);
		$settings['className'] = $helperName;

		// as we have set the className, we need to chop up the original
		// helper call if it was a plugin to set the alias correctly.
		$helperName = EvClassRegistry::getNewArrayKey($origHelper);

		return parent::loadHelper($helperName, $settings);
	}
}
