# EvCore

Base plugin for all Evoluted New Media CakePHP based websites.

## Features

### User Management

#### Google reCAPTCHA

In a bid to tackle User Enumeration attacks, Google reCAPTCHA support is available on login and registration forms. Below you will find an example implementation. Use of Google reCAPTCHA on login and registration forms is controlled through the EvCore config file (`EvCore/Config/config.php`). As default `userReCaptcha` is set to `false` and does not automatically run out of the box. Set `EvCore.userReCaptcha.login` or `EvCore.userReCaptcha.register` to `false` to use one of the two implementations available.

	<?php
		$config = [
			'EvCore' => [
				...
				// define project specific Google reCAPTCHA details below. reCAPTCHA elements
				// will automatically show on login and registration forms when login or
				// registration interactions fail by the number of allowed attempts defined
				'userReCaptcha' => [
					// replace with site specific secret
					'secret' => '',

					// replace with site specific siteKey
					'siteKey' => '',

					// the total number of failed login attempts before reCAPTCHA displays
					'showAfterFailedLoginAttempts' => 5,

					// the total number of failed registration attempts before reCAPTCHA displays
					'showAfterFailedRegisterAttempts' => 5,
				],
				...
			],
		];

Site specific Google reCAPTCHA keys can be obtained from [https://www.google.com/recaptcha/admin#list](https://www.google.com/recaptcha/admin#list)

A note to bear in mind when adding the functionality to existing sites, you will need to add the reCAPTCHA form element manually (see snippet below).

	if (isset($showReCaptcha) && $showReCaptcha === true):
        echo $this->Form->recaptcha('User.g-recaptcha-response', [
            'data-sitekey' => Configure::read('EvCore.userReCaptcha.siteKey')
        ]);
    endif;

### Extended Paginator Helper

Functionality is available out of the box to echo prev and next canonical tags in site head elements

```<?php echo $this->Paginator->canonical(); ?>```

## Admin

### Form Fields

Form fields are assigned to a CakePHP variable through the `_adminFormFields` method in `EvCoreController` based on the current model's database schema. Form fields are then added to the `admin_form` Scaffold template in `core-cms`. The `$formFields` variable is then assigned as a CakePHP template variable, typically, through the `admin_edit` Controller action.

### Form Tabs

Tabs can be added to admin forms in a number of ways. Firstly by extending the `admin_form` admin template Scaffold, or by assigning them to the `$formFields` variable in your controller.

If you are having trouble, take a gander at these links

	https://git.evoluted.net/evoluted/bambootravel/blob/dev/app/View/Themed/Admin/Scaffolds/admin_form.ctp#L41
	https://git.evoluted.net/evoluted/bambootravel/blob/dev/app/View/Themed/Admin/Scaffolds/admin_form.ctp#L69

`core-cms` is configured to convert the `tabs` key of a `$formFields` variable to individual tabs, rendering each set of fields within the `tabs` array through the `EvForm` Helper.

For example, we would like to add 'foo' and 'bar' text input forms fields to a tab with name 'Tab 1'. The key value of each nested `tabs` is used as the tab title.

	<?php
		$formFields = [
			'ModelAlias.name' => [
				'label' => 'Name',
				'type' => 'text'
			],
			...
			'tabs' => [
				'Tab 1' => [
					'ModelAlias.foo' => [
						'label' => 'Foo',
						'type' => 'text'
					],
					'ModelAlias.bar' => [
						'label' => 'Bar',
						'type' => 'text'
					]
				]
			]
		];
	?>

For a working example check any of the following

	https://git.evoluted.net/evoluted/bambootravel/blob/dev/app/Controller/AirlinesController.php#L118
	https://git.evoluted.net/premium-motorhomes/premium-motorhomes/blob/feature/rentals/app/Controller/MotorhomeRentalsController.php#L107
