<?php

App::uses('AppModel', 'Model');

class PasswordDictionary extends AppModel {

	public $useTable = 'password_dictionary';

/**
 * Populates the model's db table from supplied filepath, using a
 * default plugin based file when none is supplied
 *
 * @param string $filepath The full filepath of the required password dictory file
 * @return bool Based on whether entries were successfully saved or not
 */
	public function initalPopulate($filepath = null) {
		if (empty($filepath)) {
			$filepath = dirname(__FILE__) . DS . '..' . DS . 'Config' . DS . 'Schema' . DS . 'password_dictionary.txt';
		}

		if (file_exists($filepath)) {
			$handle = fopen($filepath, "r");
			if ($handle) {
				$dataToSave = [];

				while (($password = fgets($handle)) !== false) {
					$password = trim($password);
					if (! empty($password)) {
						$dataToSave[] = [
							'password' => $password,
							'is_active' => true
						];
					}
				}

				fclose($handle);

				if (! empty($dataToSave)) {
					$this->saveMany($dataToSave);
				}
			}
		}

		return ! empty($dataToSave);
	}

}
