<?php

App::uses('Attachment', 'EvCore.Model');

/**
 * Document attachments.
 */
class Document extends Attachment {

/**
 * Number of document slots for the current model.
 */
	public $documentSlots = 0;

/**
 * Defines number of image slots for the current model.
 */
	public $imageSlots = 0;


	public $virtualFields = array(
		'filepath' => 'CONCAT("files/document/", dir, "/", filename)'
	);

	public $actsAs = array(
		'Upload.Upload' => array(
			'filename' => array(
				'path' => '{ROOT}webroot{DS}files{DS}document{DS}',
            	'nameCallback' => 'fixUploadFilename'
			)
		)
	);


/**
 * @see Attachment::beforeSave()
 */
	public function beforeSave($options = array()) {

		// We want to store the file extension of documents in addition to the
		// file type. This is useful for displaying file icons in the views.
		if (isset($this->data[$this->alias]['filename']) && !empty($this->data[$this->alias]['filename'])) {

			preg_match('|.([A-Za-z0-9]+)$|', $this->data[$this->alias]['filename'], $matches);
			if ($matches) {
				$this->data[$this->alias]['ext'] = strtolower($matches[1]);
			}

		}

		return parent::beforeSave($options);

	}

/**
 * Called after each successful save operation.
 *
 * @param bool $created True if this save created a new record
 * @param array $options Options passed from Model::save().
 * @return void
 */
	public function afterSave($created, $options = array()) {
		// on create, add a new uuid field to the new item
		if ($created === true && ! empty($this->data[$this->alias]['id'])) {
			$this->save(
				array('uuid' => CakeText::uuid()),
				array("$this->alias.id" => $this->data[$this->alias]['id'])
			);
		}
	}

	/**
	 * callback method for uploading, allows to prefix filenames to prevent collisions and replace spaces with underscores
	 *
	 * @param string $field Name of field being modified
	 * @param string $currentName current filename
	 * @param array $data Array of data being manipulated in the current request
	 * @param array $options Array of options for the current rename
 	 * @return string
 	 */
	public function fixUploadFilename($field, $currentName, $data, $options)
	{
		return parent::fixUploadFilename($field, $currentName, $data, $options);
	}

/**
 * Queries the database to retreive data relating to the reqested id
 *
 * @param int $id The unique id number of the required item
 * @return array Contains the data array for the requested item
 */
	public function getFile($uuid) {
		$data = $this->findByUuid($uuid);

		return ! empty($data[$this->alias]) ? $data[$this->alias] : array();
	}

}
