<?php
class RemoveUniqueIndexForEmailAndSomeDefaultValuesForVariousFields extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'remove_unique_index_for_email_and_some_default_values_for_various_fields';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'alter_field' => array(
				'documents' => array(
					'model' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 64, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
				'images' => array(
					'model' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 64, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'alt' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 1024, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
				'pages' => array(
					'title' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 45, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
				'user_groups' => array(
					'name' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 45, 'key' => 'unique', 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
				'users' => array(
					'email' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 64, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'password' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 40, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
			),
			'drop_field' => array(
				'users' => array('indexes' => array('email_UNIQUE')),
			),
		),
		'down' => array(
			'alter_field' => array(
				'documents' => array(
					'model' => array('type' => 'string', 'null' => false, 'length' => 64, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
				'images' => array(
					'model' => array('type' => 'string', 'null' => false, 'length' => 64, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'alt' => array('type' => 'string', 'null' => false, 'length' => 1024, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
				'pages' => array(
					'title' => array('type' => 'string', 'null' => false, 'length' => 45, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
				'user_groups' => array(
					'name' => array('type' => 'string', 'null' => false, 'length' => 45, 'key' => 'unique', 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
				'users' => array(
					'email' => array('type' => 'string', 'null' => false, 'length' => 64, 'key' => 'unique', 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'password' => array('type' => 'string', 'null' => false, 'length' => 40, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
			),
			'create_field' => array(
				'users' => array(
					'indexes' => array(
						'email_UNIQUE' => array('column' => 'email', 'unique' => 1),
					),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
