<?php

App::uses('NumberHelper', 'View/Helper');
/**
 * Number helper library.
 *
 * Methods to make numbers more readable.
 *
 * @package       Cake.View.Helper
 * @link http://book.cakephp.org/2.0/en/core-libraries/helpers/number.html
 * @see CakeNumber
 */
class NumberExtHelper extends NumberHelper {

/**
 * Formats a number into a currency, with the given VAT % added
 *
 * @param float $number Number to format.
 * @param string $currency Shortcut to default options. Valid values are 'USD', 'EUR', 'GBP', otherwise
 *   set at least 'before' and 'after' options.
 * 'USD' is the default currency, use CakeNumber::defaultCurrency() to change this default.
 * @param array $options Options list.
 * @param integer $rate Confirming the VAT rate percentage to add to the $number
 * @return string Number formatted as a currency.
 * @see CakeNumber::currency()
 * @link http://book.cakephp.org/2.0/en/core-libraries/helpers/number.html#NumberHelper::currency
 */
	public function currencyPlusVat($number = 0, $currency = null, $options = array(), $rate = 20) {
		if (intval($rate) <> 0) {
			$number = $this->numberPlusVat($number, $rate);
		}
		return parent::currency($number, $currency, $options);
	}

/**
 * Returns given number with the requested VAT rate percentage applied
 *
 * @param float $number Number to format.
 * @param integer $rate Confirming the VAT rate percentage to add to the $number
 * @return string Number formatted as a currency.
 */
	public function numberPlusVat($number = 0, $rate = 20) {
		if (intval($rate) <> 0) {
			$number = $number * (1 + ($rate / 100));
		}
		return $number;
	}

}
