<?php

App::uses('Attachment', 'EvCore.Model');

/**
 * Document attachments.
 */
class Document extends Attachment {

/**
 * Number of document slots for the current model.
 */
	public $documentSlots = 0;

/**
 * Defines number of image slots for the current model.
 */
	public $imageSlots = 0;


	public $virtualFields = array(
		'filepath' => 'CONCAT("files/document/", dir, "/", filename)'
	);

	public $actsAs = array(
		'Upload.Upload' => array(
			'filename' => array(
				'path' => '{ROOT}webroot{DS}files{DS}document{DS}',
            	'nameCallback' => 'fixUploadFilename'
			)
		)
	);


/**
 * @see Attachment::beforeSave()
 */
	public function beforeSave($options = array()) {

		// We want to store the file extension of documents in addition to the
		// file type. This is useful for displaying file icons in the views.
		if (isset($this->data[$this->alias]['filename']) && !empty($this->data[$this->alias]['filename'])) {

			preg_match('|.([A-Za-z0-9]+)$|', $this->data[$this->alias]['filename'], $matches);
			if ($matches) {
				$this->data[$this->alias]['ext'] = strtolower($matches[1]);
			}

		}

		return parent::beforeSave($options);

	}

	/**
	 * callback method for uploading, allows to prefix filenames to prevent collisions and replace spaces with underscores
	 *
	 * @param string $field Name of field being modified
	 * @param string $currentName current filename
	 * @param array $data Array of data being manipulated in the current request
	 * @param array $options Array of options for the current rename
 	 * @return string
 	 */
	public function fixUploadFilename($field, $currentName, $data, $options)
	{
		return parent::fixUploadFilename($field, $currentName, $data, $options);
	}

}