<?php

class BasicPermissions
{
    protected $UserGroup;

    /**
     * start the class and load user Group
     */
    public function __construct($UserGroupModel)
    {
        $this->UserGroup = $UserGroupModel;
    }

    /**
     * check if the logged in user has admin permissions
     *
     * @param   array   Optional: User array to check
     * @return  bool
     */
    public function hasAdminPermission($user)
    {
        $UserGroup = $this->UserGroup;
        return $this->hasPermission($user, $UserGroup::ADMIN_LEVEL);
    }


    /**
     * check if the logged in user has super admin permissions
     *
     * @param   array   Optional: User array to check
     * @return  bool
     */
    public function hasSuperAdminPermission($user)
    {
        $UserGroup = $this->UserGroup;
        return $this->hasPermission($user, $UserGroup::SUPER_ADMIN_LEVEL);
    }


    /**
     * check if the logged in user has admin permissions
     *
     * @param   array   User array to check
     * @param   int     Permission Level to check on
     * @return  bool
     */
    public function hasPermission($user, $permission)
    {
        return (isset($user['UserGroup']['level']) && $user['UserGroup']['level'] <= $permission);
    }
}
