<?php

App::uses('AppHelper', 'View/Helper');
App::uses('BasicPermissions', 'EvCore.Lib');

class PermissionsHelper extends AppHelper
{
    public function __construct(View $View, $settings = array())
    {
        parent::__construct($View, $settings);

        $this->Permissions = new BasicPermissions(
            EvClassRegistry::init('EvCore.UserGroup')
        );
    }

    /**
     * magic method to check if the function exists in the lib file and call it if so
     * if not, it will try and return the string we were trying to Inflect
     * if it can't do that, it will just return false
     *
     */
    public function __call($name, $arguments)
    {
        if (method_exists($this->Permissions, $name)) {

            return call_user_func_array(array($this->Permissions, $name), $arguments);
        }

        // we can't find it, return false
        return false;
    }
}
